/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.json.Json;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json", "text/json", "*/*"})
public class JsonValueBodyWriter
implements MessageBodyWriter<JsonValue> {
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";
    private JsonWriterFactory wf = Json.createWriterFactory(null);
    @Context
    private Configuration config;

    @PostConstruct
    private void init() {
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        if (this.config != null && this.config.getProperties().containsKey("javax.json.stream.JsonGenerator.prettyPrinting")) {
            props.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        }
        this.wf = Json.createWriterFactory(props);
    }

    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return JsonValue.class.isAssignableFrom(aClass) && JsonValueBodyWriter.supportsMediaType(mediaType);
    }

    private static boolean supportsMediaType(MediaType mediaType) {
        return mediaType.getSubtype().equals(JSON) || mediaType.getSubtype().endsWith(PLUS_JSON);
    }

    public long getSize(JsonValue jsonValue, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(JsonValue jsonValue, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> stringObjectMultivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        try (JsonWriter writer = this.wf.createWriter(outputStream);){
            writer.write(jsonValue);
        }
    }
}

