/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.util;

public class HtmlEntityEncoder {
    private static String[] xssStrings = new String[]{"&quot;", null, null, "&#37;", "&amp;", "&#39;", "&#40;", "&#41;", null, "&#43;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&#59;", "&lt;", null, "&gt;"};
    private static final int START = 34;
    private static final char DEFAULT_CHAR = ' ';

    public static String encodeXSS(Object obj) {
        if (obj == null) {
            return null;
        }
        return HtmlEntityEncoder.encodeXSS(obj.toString());
    }

    public static String encodeXSS(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        StringBuilder sb = null;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            int ind = c - 34;
            if (ind > -1 && ind < xssStrings.length && xssStrings[ind] != null) {
                if (sb == null) {
                    sb = new StringBuilder(len);
                    sb.append(s.substring(0, i));
                }
                sb.append(xssStrings[ind]);
                continue;
            }
            if (' ' <= c && c <= '~' || '\u0080' <= c && c <= '\u00ff' || c == '\t' || Character.isWhitespace(c)) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (Character.isISOControl(c)) {
                if (sb == null) {
                    sb = new StringBuilder(len);
                    sb.append(s.substring(0, i));
                }
                sb.append(' ');
                continue;
            }
            if (Character.isHighSurrogate(c)) {
                char nextC;
                boolean valid = false;
                if (i + 1 < len && Character.isLowSurrogate(nextC = s.charAt(i + 1))) {
                    valid = true;
                    if (sb != null) {
                        sb.append(c);
                        sb.append(nextC);
                    }
                }
                if (!valid) {
                    if (sb == null) {
                        sb = new StringBuilder(len);
                        sb.append(s.substring(0, i));
                    }
                    sb.append(' ');
                }
                ++i;
                continue;
            }
            if (Character.isDefined(c)) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(len);
                sb.append(s.substring(0, i));
            }
            sb.append(' ');
        }
        if (sb != null) {
            return sb.toString();
        }
        return s;
    }
}

