/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.container.Sniffer;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-containers")
@Singleton
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.containers.command")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-containers", description="list-containers")})
@AccessRequired(resource={"domain"}, action={"read"})
public class ListContainersCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListContainersCommand.class);
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    ServiceLocator habitat;
    @Inject
    Applications applications;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionDescription(localStrings.getLocalString("list.containers.command", "List of Containers"));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ActionReport.MessagePart top = report.getTopMessagePart();
        top.setMessage(localStrings.getLocalString("list.containers.command", "List of Containers"));
        top.setChildrenType(localStrings.getLocalString("container", "Container"));
        List sniffers = this.habitat.getAllServices(Sniffer.class, new Annotation[0]);
        if (sniffers == null) {
            top.setMessage(localStrings.getLocalString("list.containers.nocontainer", "No container currently configured"));
        } else {
            for (Sniffer sniffer : sniffers) {
                ActionReport.MessagePart container = top.addChild();
                container.setMessage(sniffer.getModuleType());
                container.addProperty(localStrings.getLocalString("contractprovider", "ContractProvider"), sniffer.getModuleType());
                EngineInfo engineInfo = this.containerRegistry.getContainer(sniffer.getModuleType());
                if (engineInfo == null) continue;
                container.addProperty(localStrings.getLocalString("status", "Status"), localStrings.getLocalString("started", "Started"));
                com.sun.enterprise.module.Module connectorModule = this.modulesRegistry.find(engineInfo.getSniffer().getClass());
                container.addProperty(localStrings.getLocalString("connector", "Connector"), connectorModule.getModuleDefinition().getName() + ":" + connectorModule.getModuleDefinition().getVersion());
                container.addProperty(localStrings.getLocalString("implementation", "Implementation"), engineInfo.getContainer().getClass().toString());
                boolean atLeastOne = false;
                for (Application app : this.applications.getApplications()) {
                    for (Module module : app.getModule()) {
                        Engine engine = module.getEngine(engineInfo.getSniffer().getModuleType());
                        if (engine == null) continue;
                        if (!atLeastOne) {
                            atLeastOne = true;
                            container.setChildrenType(localStrings.getLocalString("list.containers.listapps", "Applications deployed"));
                        }
                        container.addChild().setMessage(app.getName());
                    }
                }
                if (atLeastOne) continue;
                container.addProperty("Status", "Not Started");
            }
        }
    }
}

