/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.ClassLineageIterator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import javax.annotation.PostConstruct;

public class PostConstructRunner {
    public static void runPostConstructs(final Object obj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, PrivilegedActionException {
        LinkedList<Method> postConstructMethods = new LinkedList<Method>();
        ClassLineageIterator cIT = new ClassLineageIterator(obj.getClass());
        while (cIT.hasNext()) {
            Object c = cIT.next();
            for (Method m : ((Class)c).getDeclaredMethods()) {
                if (m.getAnnotation(PostConstruct.class) == null || PostConstruct.class.isAssignableFrom((Class<?>)c) && m.getName().equals("postConstruct")) continue;
                postConstructMethods.addFirst(m);
            }
        }
        for (final Method m : postConstructMethods) {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (!m.isAccessible()) {
                        m.setAccessible(true);
                    }
                    m.invoke(obj, new Object[0]);
                    return null;
                }
            });
        }
    }
}

