/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.utils.Util;

@Consumes(value={"application/vnd.oracle.glassfish+json"})
public class RestModelListReader
implements MessageBodyReader<List<RestModel>> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String submittedType = mediaType.toString();
        int index = submittedType.indexOf(";");
        if (index > -1) {
            submittedType = submittedType.substring(0, index);
        }
        return submittedType.equals("application/vnd.oracle.glassfish+json") && List.class.isAssignableFrom(type) && RestModel.class.isAssignableFrom(Util.getFirstGenericType(genericType));
    }

    @Override
    public List<RestModel> readFrom(Class<List<RestModel>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            Locale locale = CompositeUtil.instance().getLocale(httpHeaders);
            ArrayList<RestModel> list = new ArrayList<RestModel>();
            BufferedReader in = new BufferedReader(new InputStreamReader(entityStream));
            StringBuilder sb = new StringBuilder();
            String line = in.readLine();
            while (line != null) {
                sb.append(line);
                line = in.readLine();
            }
            JSONArray array = new JSONArray(sb.toString());
            Class modelType = null;
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                modelType = (Class)pt.getActualTypeArguments()[0];
            }
            for (int i = 0; i < array.length(); ++i) {
                JSONObject o = array.getJSONObject(i);
                RestModel model = (RestModel)CompositeUtil.instance().unmarshallClass(locale, modelType, o);
                Set cv = CompositeUtil.instance().validateRestModel(locale, model);
                if (!cv.isEmpty()) {
                    Response response = Response.status(Response.Status.BAD_REQUEST).entity(CompositeUtil.instance().getValidationFailureMessages(locale, cv, model)).build();
                    throw new WebApplicationException(response);
                }
                list.add(model);
            }
            return list;
        }
        catch (Exception e) {
            throw new WebApplicationException(e);
        }
    }
}

