/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.util.EventConstants;
import org.eclipse.hono.util.Strings;
import org.eclipse.hono.util.TelemetryConstants;

public final class ResourceIdentifier {
    private static final int IDX_ENDPOINT = 0;
    private static final int IDX_TENANT_ID = 1;
    private static final int IDX_RESOURCE_ID = 2;
    private final String[] resourcePath;
    private final String resource;
    private final String basePath;

    private ResourceIdentifier(String ... path) {
        int i;
        Objects.requireNonNull(path);
        if (path.length == 0) {
            throw new IllegalArgumentException("path must have at least one segment");
        }
        if (Strings.isNullOrEmpty(path[0])) {
            throw new IllegalArgumentException("path must not start with an empty segment");
        }
        String[] pathToUse = path;
        if (path.length == 3) {
            for (i = path.length; i > 0; --i) {
                if (path[i - 1] == null) continue;
                pathToUse = Arrays.copyOfRange(path, 0, i);
                break;
            }
        }
        for (i = 0; i < pathToUse.length; ++i) {
            String segment = pathToUse[i];
            pathToUse[i] = Strings.isNullOrEmpty(segment) ? null : segment;
        }
        this.resourcePath = pathToUse;
        this.resource = this.createStringRepresentation(0);
        this.basePath = Optional.ofNullable(this.getTenantId()).map(tenant -> this.getEndpoint() + "/" + tenant).orElseGet(this::getEndpoint);
    }

    private String createStringRepresentation(int startIdx) {
        StringBuilder b = new StringBuilder();
        for (int i = startIdx; i < this.resourcePath.length; ++i) {
            if (this.resourcePath[i] != null) {
                b.append(this.resourcePath[i]);
            }
            if (i >= this.resourcePath.length - 1) continue;
            b.append("/");
        }
        return b.toString();
    }

    public static boolean isValid(String resource) {
        return !Strings.isNullOrEmpty(resource) && !resource.startsWith("/");
    }

    public static ResourceIdentifier fromString(String resource) {
        Objects.requireNonNull(resource);
        return new ResourceIdentifier(resource.split("/"));
    }

    public static ResourceIdentifier from(String endpoint, String tenantId, String resourceId) {
        Objects.requireNonNull(endpoint);
        if (endpoint.isEmpty()) {
            throw new IllegalArgumentException("endpoint must not be empty");
        }
        String[] path = resourceId == null ? (tenantId == null ? new String[]{endpoint} : new String[]{endpoint, tenantId}) : new String[]{endpoint, tenantId, resourceId};
        return new ResourceIdentifier(path);
    }

    public static ResourceIdentifier from(ResourceIdentifier resourceIdentifier, String tenantId, String resourceId) {
        Objects.requireNonNull(resourceIdentifier);
        String[] path = resourceIdentifier.getResourcePath();
        if (path.length < 3) {
            path = new String[]{resourceIdentifier.getEndpoint(), tenantId, resourceId};
        }
        return new ResourceIdentifier(path);
    }

    public static ResourceIdentifier fromPath(String ... path) {
        return new ResourceIdentifier(path);
    }

    public String[] toPath() {
        return Arrays.copyOf(this.resourcePath, this.resourcePath.length);
    }

    public String elementAt(int index) {
        return this.resourcePath[index];
    }

    public int length() {
        return this.resourcePath.length;
    }

    public String getEndpoint() {
        return this.resourcePath[0];
    }

    public String getTenantId() {
        if (this.resourcePath.length > 1) {
            return this.resourcePath[1];
        }
        return null;
    }

    public String getResourceId() {
        if (this.resourcePath.length > 2) {
            return this.resourcePath[2];
        }
        return null;
    }

    public String[] getResourcePath() {
        return Arrays.copyOf(this.resourcePath, this.resourcePath.length);
    }

    public String toString() {
        return this.resource;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getPathWithoutBase() {
        return this.createStringRepresentation(2);
    }

    public boolean hasEventEndpoint() {
        return EventConstants.isEventEndpoint(this.getEndpoint());
    }

    public boolean hasTelemetryEndpoint() {
        return TelemetryConstants.isTelemetryEndpoint(this.getEndpoint());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceIdentifier that = (ResourceIdentifier)o;
        return this.resourcePath != null ? Arrays.equals(this.resourcePath, that.resourcePath) : that.resourcePath == null;
    }

    public int hashCode() {
        return Arrays.hashCode(this.resourcePath);
    }
}

