/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.serialization;

import io.quarkus.kafka.client.serialization.JsonbDeserializer;
import io.quarkus.kafka.client.serialization.JsonbProducer;
import io.quarkus.kafka.client.serialization.JsonbSerializer;
import java.util.Map;
import javax.json.bind.Jsonb;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

public class JsonbSerde<T>
implements Serde<T> {
    private final Jsonb jsonb;
    private final boolean jsonbNeedsClosing;
    private final JsonbSerializer<T> serializer;
    private final JsonbDeserializer<T> deserializer;

    public JsonbSerde(Class<T> type) {
        this(type, JsonbProducer.get(), true);
    }

    public JsonbSerde(Class<T> type, Jsonb jsonb) {
        this(type, jsonb, false);
    }

    private JsonbSerde(Class<T> type, Jsonb jsonb, boolean jsonbNeedsClosing) {
        this.jsonb = jsonb;
        this.jsonbNeedsClosing = jsonbNeedsClosing;
        this.serializer = new JsonbSerializer(jsonb);
        this.deserializer = new JsonbDeserializer<T>(type, jsonb);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public void close() {
        this.serializer.close();
        this.deserializer.close();
        if (this.jsonbNeedsClosing) {
            try {
                this.jsonb.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Serializer<T> serializer() {
        return this.serializer;
    }

    @Override
    public Deserializer<T> deserializer() {
        return this.deserializer;
    }
}

