/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.spi;

import java.security.AccessController;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.eclipse.microprofile.context.spi.ContextManagerProviderRegistration;

public interface ContextManagerProvider {
    public static final AtomicReference<ContextManagerProvider> INSTANCE = new AtomicReference();

    public static ContextManagerProvider instance() {
        ContextManagerProvider provider = INSTANCE.get();
        if (provider == null) {
            for (ContextManagerProvider serviceProvider : ServiceLoader.load(ContextManagerProvider.class)) {
                if (INSTANCE.compareAndSet(null, serviceProvider)) {
                    provider = serviceProvider;
                    continue;
                }
                throw new IllegalStateException("ContextManagerProvider already set");
            }
            if (provider == null) {
                throw new IllegalStateException("Container has not registered a ContextManagerProvider");
            }
        }
        return provider;
    }

    public static ContextManagerProviderRegistration register(ContextManagerProvider provider) throws IllegalStateException {
        if (INSTANCE.compareAndSet(null, provider)) {
            return new ContextManagerProviderRegistration(provider);
        }
        throw new IllegalStateException("A ContextManagerProvider implementation has already been registered.");
    }

    default public ContextManager getContextManager() {
        ClassLoader loader = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        return this.getContextManager(loader);
    }

    public ContextManager getContextManager(ClassLoader var1);

    default public ContextManager.Builder getContextManagerBuilder() {
        throw new UnsupportedOperationException();
    }

    default public void registerContextManager(ContextManager manager, ClassLoader classLoader) {
        throw new UnsupportedOperationException();
    }

    default public void releaseContextManager(ContextManager manager) {
        throw new UnsupportedOperationException();
    }
}

