/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.config.AbstractLocationConfigSourceFactory;
import io.smallrye.config.ConfigLogging;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigValueConverter;
import io.smallrye.config.ConfigurableConfigSource;
import io.smallrye.config.Converters;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.Expressions;
import io.smallrye.config.ImplicitConverters;
import io.smallrye.config.NameIterator;
import io.smallrye.config.ProfileConfigSourceFactory;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.PropertyNamesConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigSourceContext;
import io.smallrye.config.SmallRyeConfigSourceInterceptorContext;
import io.smallrye.config.SmallRyeConfigSources;
import io.smallrye.config.common.utils.StringUtil;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfig
implements Config,
Serializable {
    public static final String SMALLRYE_CONFIG_PROFILE = "smallrye.config.profile";
    public static final String SMALLRYE_CONFIG_PROFILE_PARENT = "smallrye.config.profile.parent";
    public static final String SMALLRYE_CONFIG_LOCATIONS = "smallrye.config.locations";
    public static final String SMALLRYE_CONFIG_MAPPING_VALIDATE_UNKNOWN = "smallrye.config.mapping.validate-unknown";
    private static final long serialVersionUID = 8138651532357898263L;
    private final ConfigSources configSources;
    private final Map<Type, Converter<?>> converters;
    private final Map<Type, Converter<Optional<?>>> optionalConverters = new ConcurrentHashMap();
    private final ConfigMappings mappings;

    SmallRyeConfig(SmallRyeConfigBuilder builder) {
        this.configSources = new ConfigSources(builder);
        this.converters = this.buildConverters(builder);
        this.mappings = new ConfigMappings(builder.getValidator());
    }

    private Map<Type, Converter<?>> buildConverters(SmallRyeConfigBuilder builder) {
        HashMap<Type, SmallRyeConfigBuilder.ConverterWithPriority> convertersToBuild = new HashMap<Type, SmallRyeConfigBuilder.ConverterWithPriority>(builder.getConverters());
        if (builder.isAddDiscoveredConverters()) {
            for (Converter<?> converter : builder.discoverConverters()) {
                Type type = Converters.getConverterType(converter.getClass());
                if (type == null) {
                    throw ConfigMessages.msg.unableToAddConverter(converter);
                }
                SmallRyeConfigBuilder.addConverter(type, converter, convertersToBuild);
            }
        }
        ConcurrentHashMap converters = new ConcurrentHashMap(Converters.ALL_CONVERTERS);
        for (Map.Entry entry : convertersToBuild.entrySet()) {
            converters.put((Type)entry.getKey(), ((SmallRyeConfigBuilder.ConverterWithPriority)entry.getValue()).getConverter());
        }
        converters.put((Type)((Object)ConfigValue.class), ConfigValueConverter.CONFIG_VALUE_CONVERTER);
        return converters;
    }

    @Override
    public <T> List<T> getValues(String propertyName, Class<T> propertyType) {
        return this.getValues(propertyName, propertyType, ArrayList::new);
    }

    public <T, C extends Collection<T>> C getValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getValues(name, this.requireConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> C getValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        try {
            return (C)((Collection)this.getValue(name, Converters.newCollectionConverter(converter, collectionFactory)));
        }
        catch (NoSuchElementException e) {
            return this.getIndexedValues(name, converter, collectionFactory);
        }
    }

    public <T, C extends Collection<T>> C getIndexedValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        List<String> indexedProperties = this.getIndexedProperties(name);
        if (indexedProperties.isEmpty()) {
            throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(name));
        }
        Collection collection = (Collection)collectionFactory.apply(indexedProperties.size());
        for (String indexedProperty : indexedProperties) {
            collection.add(this.getValue(indexedProperty, converter));
        }
        return (C)collection;
    }

    public List<String> getIndexedProperties(String property) {
        List<Integer> indexes = this.getIndexedPropertiesIndexes(property);
        ArrayList<String> indexedProperties = new ArrayList<String>();
        for (Integer index : indexes) {
            indexedProperties.add(property + "[" + index + "]");
        }
        return indexedProperties;
    }

    public List<Integer> getIndexedPropertiesIndexes(String property) {
        HashSet<Integer> indexes = new HashSet<Integer>();
        block2: for (String propertyName : this.getPropertyNames()) {
            int index;
            if (!propertyName.startsWith(property) || propertyName.length() <= property.length() || propertyName.charAt(index = property.length()) != '[') continue;
            while (true) {
                if (propertyName.charAt(index) == ']') {
                    try {
                        indexes.add(Integer.parseInt(propertyName.substring(property.length() + 1, index)));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block2;
                }
                if (index >= propertyName.length() - 1) continue block2;
                ++index;
            }
        }
        ArrayList<Integer> sortIndexes = new ArrayList<Integer>(indexes);
        Collections.sort(sortIndexes);
        return sortIndexes;
    }

    @Override
    public <T> T getValue(String name, Class<T> aClass) {
        return this.getValue(name, this.requireConverter(aClass));
    }

    public <K, V> Map<K, V> getValues(String name, Class<K> kClass, Class<V> vClass) {
        Map<K, V> result = this.getValuesAsMap(name, this.requireConverter(kClass), this.requireConverter(vClass));
        if (result == null) {
            throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(name));
        }
        return result;
    }

    public <K, V> Map<K, V> getValuesAsMap(String name, Converter<K> keyConverter, Converter<V> valueConverter) {
        Object prefix = name.endsWith(".") ? name : name + ".";
        HashMap<K, V> result = new HashMap<K, V>();
        for (String propertyName : this.getPropertyNames()) {
            if (!propertyName.startsWith((String)prefix)) continue;
            NameIterator nameIterator = new NameIterator(propertyName, ((String)prefix).length() - 1);
            if (nameIterator.hasNext()) {
                nameIterator.next();
                if (nameIterator.hasNext()) continue;
                nameIterator.previous();
            }
            String key = nameIterator.getNextSegment();
            ConfigValue configValueKey = ConfigValue.builder().withName(propertyName + "#key").withValue(key).build();
            ConfigValue configValue = this.getConfigValue(propertyName).withName(propertyName + "#value");
            result.put(this.convertValue(configValueKey, keyConverter), this.convertValue(configValue, valueConverter));
        }
        return result.isEmpty() ? null : result;
    }

    public <T> T getValue(String name, Converter<T> converter) {
        ConfigValue configValue = this.getConfigValue(name);
        if (ConfigValueConverter.CONFIG_VALUE_CONVERTER.equals(converter)) {
            return (T)configValue.noProblems();
        }
        if (converter instanceof Converters.OptionalConverter && ConfigValueConverter.CONFIG_VALUE_CONVERTER.equals(((Converters.OptionalConverter)converter).getDelegate())) {
            return (T)Optional.of(configValue.noProblems());
        }
        return this.convertValue(configValue, converter);
    }

    public <T> T convertValue(ConfigValue configValue, Converter<T> converter) {
        T converted;
        List<ConfigValidationException.Problem> problems = configValue.getProblems();
        if (!problems.isEmpty()) {
            if (Converters.isOptionalConverter(converter)) {
                configValue = configValue.noProblems();
            } else {
                ConfigValidationException.Problem problem = problems.get(0);
                Optional<RuntimeException> exception = problem.getException();
                if (exception.isPresent()) {
                    throw exception.get();
                }
            }
        }
        if (configValue.getValue() != null) {
            try {
                converted = converter.convert(configValue.getValue());
            }
            catch (IllegalArgumentException e) {
                throw ConfigMessages.msg.converterException(e, configValue.getNameProfiled(), configValue.getValue(), e.getLocalizedMessage());
            }
        }
        try {
            converted = converter.convert("");
        }
        catch (IllegalArgumentException ignored) {
            throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(configValue.getNameProfiled()));
        }
        if (converted == null) {
            if (configValue.getValue() == null) {
                throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(configValue.getNameProfiled()));
            }
            if (configValue.getValue().length() == 0) {
                throw ConfigMessages.msg.propertyEmptyString(configValue.getNameProfiled(), converter.getClass().getTypeName());
            }
            throw ConfigMessages.msg.converterReturnedNull(configValue.getNameProfiled(), configValue.getValue(), converter.getClass().getTypeName());
        }
        return converted;
    }

    public boolean rawValueEquals(String name, String expected) {
        return Objects.equals(expected, this.getRawValue(name));
    }

    @Override
    public ConfigValue getConfigValue(String name) {
        ConfigValue configValue = this.configSources.getInterceptorChain().proceed(name);
        return configValue != null ? configValue : ConfigValue.builder().withName(name).build();
    }

    public String getRawValue(String name) {
        ConfigValue configValue = this.getConfigValue(name);
        return configValue != null && configValue.getValue() != null ? configValue.getValue() : null;
    }

    @Override
    public <T> Optional<T> getOptionalValue(String name, Class<T> aClass) {
        return this.getValue(name, this.getOptionalConverter(aClass));
    }

    public <K, V> Optional<Map<K, V>> getOptionalValues(String name, Class<K> kClass, Class<V> vClass) {
        return Optional.ofNullable(this.getValuesAsMap(name, this.requireConverter(kClass), this.requireConverter(vClass)));
    }

    public <T> Optional<T> getOptionalValue(String name, Converter<T> converter) {
        return this.getValue(name, Converters.newOptionalConverter(converter));
    }

    @Override
    public <T> Optional<List<T>> getOptionalValues(String propertyName, Class<T> propertyType) {
        return this.getOptionalValues(propertyName, propertyType, ArrayList::new);
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getOptionalValues(name, this.requireConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        Optional<C> optionalValue = this.getOptionalValue(name, Converters.newCollectionConverter(converter, collectionFactory));
        if (optionalValue.isPresent()) {
            return optionalValue;
        }
        return this.getIndexedOptionalValues(name, converter, collectionFactory);
    }

    public <T, C extends Collection<T>> Optional<C> getIndexedOptionalValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        List<String> indexedProperties = this.getIndexedProperties(name);
        if (indexedProperties.isEmpty()) {
            return Optional.empty();
        }
        Collection collection = (Collection)collectionFactory.apply(indexedProperties.size());
        for (String indexedProperty : indexedProperties) {
            Optional<Object> optionalValue = this.getOptionalValue(indexedProperty, converter);
            optionalValue.ifPresent(collection::add);
        }
        if (!collection.isEmpty()) {
            return Optional.of(collection);
        }
        return Optional.empty();
    }

    public ConfigMappings getConfigMappings() {
        return this.mappings;
    }

    public <T> T getConfigMapping(Class<T> type) {
        return this.mappings.getConfigMapping(type);
    }

    public <T> T getConfigMapping(Class<T> type, String prefix) {
        return this.mappings.getConfigMapping(type, prefix);
    }

    @Override
    public Iterable<String> getPropertyNames() {
        return this.configSources.getPropertyNames().get();
    }

    @Experimental(value="Check if a property is present")
    public boolean isPropertyPresent(String name) {
        return Expressions.withoutExpansion(() -> this.getConfigValue(name).getValue() != null);
    }

    @Override
    public Iterable<ConfigSource> getConfigSources() {
        return this.configSources.getSources();
    }

    public Iterable<ConfigSource> getConfigSources(Class<?> type) {
        ArrayList<ConfigSource> configSourcesByType = new ArrayList<ConfigSource>();
        for (ConfigSource configSource : this.getConfigSources()) {
            if (!type.isAssignableFrom(configSource.getClass())) continue;
            configSourcesByType.add(configSource);
        }
        return configSourcesByType;
    }

    @Experimental(value="To retrieve a ConfigSource by name")
    public Optional<ConfigSource> getConfigSource(String name) {
        for (ConfigSource configSource : this.getConfigSources()) {
            String configSourceName = configSource.getName();
            if (configSourceName == null || !configSourceName.equals(name)) continue;
            return Optional.of(configSource);
        }
        return Optional.empty();
    }

    public <T> T convert(String value, Class<T> asType) {
        return value != null ? (T)this.requireConverter(asType).convert(value) : null;
    }

    private <T> Converter<Optional<T>> getOptionalConverter(Class<T> asType) {
        return this.optionalConverters.computeIfAbsent(asType, clazz -> Converters.newOptionalConverter(this.requireConverter((Class)clazz)));
    }

    @Override
    public <T> Optional<Converter<T>> getConverter(Class<T> asType) {
        return Optional.ofNullable(this.getConverterOrNull(asType));
    }

    public <T> Converter<T> requireConverter(Class<T> asType) {
        Converter<T> conv = this.getConverterOrNull(asType);
        if (conv == null) {
            throw ConfigMessages.msg.noRegisteredConverter(asType);
        }
        return conv;
    }

    <T> Converter<T> getConverterOrNull(Class<T> asType) {
        Converter<?> exactConverter = this.converters.get(asType);
        if (exactConverter != null) {
            return exactConverter;
        }
        if (asType.isPrimitive()) {
            return this.getConverterOrNull(Converters.wrapPrimitiveType(asType));
        }
        if (asType.isArray()) {
            Converter<?> conv = this.getConverterOrNull(asType.getComponentType());
            return conv == null ? null : Converters.newArrayConverter(conv, asType);
        }
        return this.converters.computeIfAbsent(asType, clazz -> ImplicitConverters.getConverter((Class)clazz));
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        if (Config.class.isAssignableFrom(type)) {
            return type.cast(this);
        }
        throw ConfigMessages.msg.getTypeNotSupportedForUnwrapping(type);
    }

    public List<String> getProfiles() {
        return this.configSources.getProfiles();
    }

    void addPropertyNames(Set<String> properties) {
        this.configSources.getPropertyNames().add(properties);
    }

    private Object writeReplace() throws ObjectStreamException {
        return RegisteredConfig.instance;
    }

    private static class RegisteredConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final RegisteredConfig instance = new RegisteredConfig();

        private RegisteredConfig() {
        }

        private Object readResolve() throws ObjectStreamException {
            return ConfigProvider.getConfig();
        }
    }

    static class ConfigSourceWithPriority
    implements Comparable<ConfigSourceWithPriority>,
    Serializable {
        private static final long serialVersionUID = 3709554647398262957L;
        private final ConfigSource source;
        private final int priority;
        private final int loadPriority = loadPrioritySequence++;
        private static int loadPrioritySequence = 0;

        ConfigSourceWithPriority(ConfigSource source) {
            this.source = source;
            this.priority = source.getOrdinal();
        }

        ConfigSource getSource() {
            return this.source;
        }

        @Override
        public int compareTo(ConfigSourceWithPriority other) {
            int res = Integer.compare(this.priority, other.priority);
            return res != 0 ? res : Integer.compare(other.loadPriority, this.loadPriority);
        }

        static void resetLoadPriority() {
            loadPrioritySequence = 0;
        }
    }

    private static class ConfigSources
    implements Serializable {
        private static final long serialVersionUID = 3483018375584151712L;
        private final List<String> profiles;
        private final List<ConfigSource> sources;
        private final ConfigSourceInterceptorContext interceptorChain;
        private final PropertyNames propertyNames;

        ConfigSources(SmallRyeConfigBuilder builder) {
            List<ConfigSource> sources = ConfigSources.buildSources(builder);
            ArrayList<ConfigSourceInterceptor> interceptors = new ArrayList<ConfigSourceInterceptor>();
            List<SmallRyeConfigBuilder.InterceptorWithPriority> interceptorWithPriorities = ConfigSources.buildInterceptors(builder);
            SmallRyeConfigSourceInterceptorContext current = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null);
            current = new SmallRyeConfigSourceInterceptorContext(new SmallRyeConfigSources(ConfigSources.mapSources(sources)), current);
            for (SmallRyeConfigBuilder.InterceptorWithPriority interceptorWithPriority : interceptorWithPriorities) {
                ConfigSourceInterceptor interceptor = interceptorWithPriority.getInterceptor(current);
                interceptors.add(interceptor);
                current = new SmallRyeConfigSourceInterceptorContext(interceptor, current);
            }
            List<String> profiles = ConfigSources.getProfiles(interceptors);
            List<ConfigSourceWithPriority> sourcesWithPriorities = ConfigSources.mapLateSources(sources, interceptors, current, profiles, builder);
            current = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null);
            current = new SmallRyeConfigSourceInterceptorContext(new SmallRyeConfigSources(sourcesWithPriorities), current);
            for (ConfigSourceInterceptor interceptor : interceptors) {
                current = new SmallRyeConfigSourceInterceptorContext(interceptor, current);
            }
            List<ConfigSource> configSources = ConfigSources.getSources(sourcesWithPriorities);
            PropertyNamesConfigSourceInterceptor propertyNamesInterceptor = new PropertyNamesConfigSourceInterceptor();
            current = new SmallRyeConfigSourceInterceptorContext(propertyNamesInterceptor, current);
            PropertyNames propertyNames = new PropertyNames(propertyNamesInterceptor);
            propertyNames.add(ConfigSources.generateDottedProperties(configSources, current));
            this.profiles = profiles;
            this.sources = configSources;
            this.interceptorChain = current;
            this.propertyNames = propertyNames;
        }

        private static List<ConfigSource> buildSources(SmallRyeConfigBuilder builder) {
            ArrayList<ConfigSource> sourcesToBuild = new ArrayList<ConfigSource>(builder.getSources());
            for (ConfigSourceProvider sourceProvider : builder.getSourceProviders()) {
                for (ConfigSource configSource : sourceProvider.getConfigSources(builder.getClassLoader())) {
                    sourcesToBuild.add(configSource);
                }
            }
            if (builder.isAddDiscoveredSources()) {
                sourcesToBuild.addAll(builder.discoverSources());
            }
            if (builder.isAddDefaultSources()) {
                sourcesToBuild.addAll(builder.getDefaultSources());
            }
            sourcesToBuild.add(new DefaultValuesConfigSource(builder.getDefaultValues()));
            return sourcesToBuild;
        }

        private static List<SmallRyeConfigBuilder.InterceptorWithPriority> buildInterceptors(SmallRyeConfigBuilder builder) {
            ArrayList<SmallRyeConfigBuilder.InterceptorWithPriority> interceptors = new ArrayList<SmallRyeConfigBuilder.InterceptorWithPriority>(builder.getInterceptors());
            if (builder.isAddDiscoveredInterceptors()) {
                interceptors.addAll(builder.discoverInterceptors());
            }
            if (builder.isAddDefaultInterceptors()) {
                interceptors.addAll(builder.getDefaultInterceptors());
            }
            interceptors.sort(null);
            return interceptors;
        }

        private static List<ConfigSourceWithPriority> mapSources(List<ConfigSource> sources) {
            ArrayList<ConfigSourceWithPriority> sourcesWithPriority = new ArrayList<ConfigSourceWithPriority>();
            for (ConfigSource source : sources) {
                if (source instanceof ConfigurableConfigSource) continue;
                sourcesWithPriority.add(new ConfigSourceWithPriority(source));
            }
            sourcesWithPriority.sort(null);
            Collections.reverse(sourcesWithPriority);
            return sourcesWithPriority;
        }

        private static List<String> getProfiles(List<ConfigSourceInterceptor> interceptors) {
            for (ConfigSourceInterceptor interceptor : interceptors) {
                if (!(interceptor instanceof ProfileConfigSourceInterceptor)) continue;
                return Arrays.asList(((ProfileConfigSourceInterceptor)interceptor).getProfiles());
            }
            return Collections.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        private static List<ConfigSourceWithPriority> mapLateSources(List<ConfigSource> sources, List<ConfigSourceInterceptor> interceptors, ConfigSourceInterceptorContext current, List<String> profiles, SmallRyeConfigBuilder builder) {
            ConfigValue locations;
            void var9_12;
            ConfigSourceWithPriority.resetLoadPriority();
            ArrayList<ConfigSourceWithPriority> currentSources = new ArrayList<ConfigSourceWithPriority>();
            ArrayList<ConfigSource> profileSources = new ArrayList<ConfigSource>();
            SmallRyeConfigSourceContext mainContext = new SmallRyeConfigSourceContext(current, profiles);
            for (ConfigurableConfigSource configurableConfigSource : ConfigSources.getConfigurableSources(sources)) {
                if (!(configurableConfigSource.getFactory() instanceof ProfileConfigSourceFactory)) continue;
                profileSources.addAll(configurableConfigSource.getConfigSources(mainContext));
            }
            currentSources.addAll(ConfigSources.mapSources(profileSources));
            currentSources.addAll(ConfigSources.mapSources(sources));
            currentSources.sort(null);
            Collections.reverse(currentSources);
            SmallRyeConfigSourceInterceptorContext context = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null);
            context = new SmallRyeConfigSourceInterceptorContext(new SmallRyeConfigSources(currentSources), context);
            for (ConfigSourceInterceptor interceptor : interceptors) {
                context = new SmallRyeConfigSourceInterceptorContext(interceptor, context);
            }
            boolean bl = false;
            ArrayList<ConfigSource> lateSources = new ArrayList<ConfigSource>();
            SmallRyeConfigSourceContext profileContext = new SmallRyeConfigSourceContext(context, profiles);
            for (ConfigurableConfigSource lateSource : ConfigSources.getConfigurableSources(sources)) {
                if (lateSource.getFactory() instanceof ProfileConfigSourceFactory) continue;
                List<ConfigSource> configSources = lateSource.getConfigSources(profileContext);
                if (lateSource.getFactory() instanceof AbstractLocationConfigSourceFactory) {
                    var9_12 += configSources.size();
                }
                lateSources.addAll(configSources);
            }
            if (var9_12 == false && builder.isAddDiscoveredSources() && (locations = profileContext.getValue(SmallRyeConfig.SMALLRYE_CONFIG_LOCATIONS)) != null && locations.getValue() != null) {
                ConfigLogging.log.configLocationsNotFound(SmallRyeConfig.SMALLRYE_CONFIG_LOCATIONS, locations.getValue());
            }
            currentSources.clear();
            currentSources.addAll(ConfigSources.mapSources(lateSources));
            currentSources.addAll(ConfigSources.mapSources(profileSources));
            currentSources.addAll(ConfigSources.mapSources(sources));
            currentSources.sort(null);
            Collections.reverse(currentSources);
            return currentSources;
        }

        private static List<ConfigSource> getSources(List<ConfigSourceWithPriority> sourceWithPriorities) {
            ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
            for (ConfigSourceWithPriority configSourceWithPriority : sourceWithPriorities) {
                configSources.add(configSourceWithPriority.getSource());
            }
            return Collections.unmodifiableList(configSources);
        }

        private static List<ConfigurableConfigSource> getConfigurableSources(List<ConfigSource> sources) {
            ArrayList<ConfigurableConfigSource> configurableConfigSources = new ArrayList<ConfigurableConfigSource>();
            for (ConfigSource source : sources) {
                if (!(source instanceof ConfigurableConfigSource)) continue;
                configurableConfigSources.add((ConfigurableConfigSource)source);
            }
            configurableConfigSources.sort(Comparator.comparingInt(ConfigurableConfigSource::getOrdinal).reversed());
            return Collections.unmodifiableList(configurableConfigSources);
        }

        private static Set<String> generateDottedProperties(List<ConfigSource> sources, SmallRyeConfigSourceInterceptorContext current) {
            HashSet<String> properties = new HashSet<String>();
            Iterator<String> iterateNames = current.iterateNames();
            while (iterateNames.hasNext()) {
                properties.add(iterateNames.next());
            }
            HashSet<String> envProperties = new HashSet<String>();
            for (ConfigSource configSource : sources) {
                if (!(configSource instanceof EnvConfigSource)) continue;
                envProperties.addAll(configSource.getPropertyNames());
            }
            properties.removeAll(envProperties);
            HashSet<String> overrides = new HashSet<String>();
            block2: for (String property : properties) {
                String semanticProperty = StringUtil.replaceNonAlphanumericByUnderscores(property);
                for (String envProperty : envProperties) {
                    if (!envProperty.equalsIgnoreCase(semanticProperty)) continue;
                    overrides.add(envProperty);
                    continue block2;
                }
            }
            envProperties.removeAll(overrides);
            HashSet<String> hashSet = new HashSet<String>();
            for (String envProperty : envProperties) {
                hashSet.add(StringUtil.toLowerCaseAndDotted(envProperty));
            }
            return hashSet;
        }

        List<String> getProfiles() {
            return this.profiles;
        }

        List<ConfigSource> getSources() {
            return this.sources;
        }

        ConfigSourceInterceptorContext getInterceptorChain() {
            return this.interceptorChain;
        }

        PropertyNames getPropertyNames() {
            return this.propertyNames;
        }

        class PropertyNames
        implements Serializable {
            private static final long serialVersionUID = 4193517748286869745L;
            private final PropertyNamesConfigSourceInterceptor interceptor;

            private PropertyNames(PropertyNamesConfigSourceInterceptor propertyNamesInterceptor) {
                this.interceptor = propertyNamesInterceptor;
            }

            Iterable<String> get() {
                HashSet<String> names = new HashSet<String>();
                Iterator<String> namesIterator = ConfigSources.this.interceptorChain.iterateNames();
                while (namesIterator.hasNext()) {
                    names.add(namesIterator.next());
                }
                return names;
            }

            void add(Set<String> properties) {
                this.interceptor.addProperties(properties);
            }
        }
    }
}

