/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfig;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfigBuilder;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfigFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class DeploymentRollbackFluentImpl<A extends DeploymentRollbackFluent<A>>
extends BaseFluent<A>
implements DeploymentRollbackFluent<A> {
    private String apiVersion;
    private String kind;
    private String name;
    private RollbackConfigBuilder rollbackTo;
    private Map<String, String> updatedAnnotations;
    private Map<String, Object> additionalProperties;

    public DeploymentRollbackFluentImpl() {
    }

    public DeploymentRollbackFluentImpl(DeploymentRollback instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withRollbackTo(instance.getRollbackTo());
            this.withUpdatedAnnotations(instance.getUpdatedAnnotations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public RollbackConfig getRollbackTo() {
        return this.rollbackTo != null ? this.rollbackTo.build() : null;
    }

    @Override
    public RollbackConfig buildRollbackTo() {
        return this.rollbackTo != null ? this.rollbackTo.build() : null;
    }

    @Override
    public A withRollbackTo(RollbackConfig rollbackTo) {
        this._visitables.get("rollbackTo").remove(this.rollbackTo);
        if (rollbackTo != null) {
            this.rollbackTo = new RollbackConfigBuilder(rollbackTo);
            this._visitables.get("rollbackTo").add(this.rollbackTo);
        } else {
            this.rollbackTo = null;
            this._visitables.get("rollbackTo").remove(this.rollbackTo);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRollbackTo() {
        return this.rollbackTo != null;
    }

    @Override
    public A withNewRollbackTo(Long revision) {
        return this.withRollbackTo(new RollbackConfig(revision));
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<A> withNewRollbackTo() {
        return new RollbackToNestedImpl();
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<A> withNewRollbackToLike(RollbackConfig item) {
        return new RollbackToNestedImpl(item);
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<A> editRollbackTo() {
        return this.withNewRollbackToLike(this.getRollbackTo());
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<A> editOrNewRollbackTo() {
        return this.withNewRollbackToLike(this.getRollbackTo() != null ? this.getRollbackTo() : new RollbackConfigBuilder().build());
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<A> editOrNewRollbackToLike(RollbackConfig item) {
        return this.withNewRollbackToLike(this.getRollbackTo() != null ? this.getRollbackTo() : item);
    }

    @Override
    public A addToUpdatedAnnotations(String key, String value) {
        if (this.updatedAnnotations == null && key != null && value != null) {
            this.updatedAnnotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.updatedAnnotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToUpdatedAnnotations(Map<String, String> map) {
        if (this.updatedAnnotations == null && map != null) {
            this.updatedAnnotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.updatedAnnotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromUpdatedAnnotations(String key) {
        if (this.updatedAnnotations == null) {
            return (A)this;
        }
        if (key != null && this.updatedAnnotations != null) {
            this.updatedAnnotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromUpdatedAnnotations(Map<String, String> map) {
        if (this.updatedAnnotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.updatedAnnotations == null) continue;
                this.updatedAnnotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getUpdatedAnnotations() {
        return this.updatedAnnotations;
    }

    @Override
    public <K, V> A withUpdatedAnnotations(Map<String, String> updatedAnnotations) {
        this.updatedAnnotations = updatedAnnotations == null ? null : new LinkedHashMap<String, String>(updatedAnnotations);
        return (A)this;
    }

    @Override
    public Boolean hasUpdatedAnnotations() {
        return this.updatedAnnotations != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentRollbackFluentImpl that = (DeploymentRollbackFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.rollbackTo, that.rollbackTo)) {
            return false;
        }
        if (!Objects.equals(this.updatedAnnotations, that.updatedAnnotations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.name, this.rollbackTo, this.updatedAnnotations, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.rollbackTo != null) {
            sb.append("rollbackTo:");
            sb.append(this.rollbackTo + ",");
        }
        if (this.updatedAnnotations != null && !this.updatedAnnotations.isEmpty()) {
            sb.append("updatedAnnotations:");
            sb.append(this.updatedAnnotations + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class RollbackToNestedImpl<N>
    extends RollbackConfigFluentImpl<DeploymentRollbackFluent.RollbackToNested<N>>
    implements DeploymentRollbackFluent.RollbackToNested<N>,
    Nested<N> {
        RollbackConfigBuilder builder;

        RollbackToNestedImpl(RollbackConfig item) {
            this.builder = new RollbackConfigBuilder(this, item);
        }

        RollbackToNestedImpl() {
            this.builder = new RollbackConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentRollbackFluentImpl.this.withRollbackTo(this.builder.build());
        }

        @Override
        public N endRollbackTo() {
            return this.and();
        }
    }
}

