/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime.devui.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.utils.Bytes;

public class ConsumerFactory {
    public static Consumer<Bytes, Bytes> createConsumer(String topicName, Integer requestedPartition, Map<String, Object> commonConfig) {
        return ConsumerFactory.createConsumer(List.of(new TopicPartition(topicName, requestedPartition)), commonConfig);
    }

    public static Consumer<Bytes, Bytes> createConsumer(Collection<TopicPartition> requestedPartitions, Map<String, Object> commonConfig) {
        HashMap<String, Object> config = new HashMap<String, Object>(commonConfig);
        config.put("key.deserializer", BytesDeserializer.class);
        config.put("value.deserializer", BytesDeserializer.class);
        config.put("client.id", "kafka-ui-" + UUID.randomUUID());
        config.put("enable.auto.commit", "false");
        KafkaConsumer<Bytes, Bytes> consumer = new KafkaConsumer<Bytes, Bytes>(config);
        consumer.assign(requestedPartitions);
        return consumer;
    }
}

