/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiSubscribe;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class VertxContextSupport {
    private VertxContextSupport() {
    }

    public static <T> T subscribeAndAwait(final Supplier<Uni<T>> uniSupplier) throws Throwable {
        Context context = VertxContextSupport.getContext();
        VertxContextSafetyToggle.setContextSafe(context, true);
        return Uni.createFrom().emitter(e -> context.runOnContext(new Handler<Void>(){

            @Override
            public void handle(Void event) {
                ManagedContext requestContext = Arc.container().requestContext();
                Runnable terminate = null;
                if (!requestContext.isActive()) {
                    requestContext.activate();
                    terminate = requestContext::terminate;
                }
                try {
                    Uni uni = (Uni)uniSupplier.get();
                    if (terminate != null) {
                        uni = uni.onTermination().invoke(terminate);
                    }
                    uni.subscribe().with(e::complete, e::fail);
                }
                catch (Throwable t) {
                    e.fail(t);
                }
            }
        })).await().indefinitely();
    }

    public static <T> void subscribe(final Supplier<Multi<T>> multiSupplier, final Consumer<MultiSubscribe<T>> subscribeConsumer) {
        Context context = VertxContextSupport.getContext();
        VertxContextSafetyToggle.setContextSafe(context, true);
        context.runOnContext(new Handler<Void>(){

            @Override
            public void handle(Void event) {
                subscribeConsumer.accept(((Multi)multiSupplier.get()).subscribe());
            }
        });
    }

    public static <T> void subscribeWith(Supplier<Multi<T>> multiSupplier, final Consumer<? super T> onItem) {
        VertxContextSupport.subscribe(multiSupplier, new Consumer<MultiSubscribe<T>>(){

            @Override
            public void accept(MultiSubscribe<T> ms) {
                ms.with(onItem);
            }
        });
    }

    private static Context getContext() {
        Context context = Vertx.currentContext();
        if (context == null) {
            Vertx vertx = VertxCoreRecorder.getVertx().get();
            context = VertxContext.getOrCreateDuplicatedContext(vertx);
        } else {
            if (Context.isOnEventLoopThread()) {
                throw new IllegalStateException("VertxContextSupport#subscribeAndAwait() must not be called on an event loop!");
            }
            context = VertxContext.getOrCreateDuplicatedContext(context);
        }
        return context;
    }
}

