/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.types;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.incquery.patternlanguage.emf.types.EMFPatternTypeProvider;
import org.eclipse.incquery.patternlanguage.emf.util.IErrorFeedback;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.diagnostics.Severity;

@Singleton
public class GenModelBasedTypeProvider
extends EMFPatternTypeProvider {
    @Inject
    private IEiqGenmodelProvider genModelProvider;
    @Inject
    private IErrorFeedback errorFeedback;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private Primitives primitives;

    protected JvmTypeReference getTypeReferenceForVariableWithEClassifier(EClassifier classifier, Variable variable) {
        GenPackage genPackage;
        EPackage ePackage;
        JvmTypeReference typeReference = super.getTypeReferenceForVariableWithEClassifier(classifier, variable);
        if (typeReference == null && classifier != null && (ePackage = classifier.getEPackage()) != null && (genPackage = this.genModelProvider.findGenPackage((EObject)variable, ePackage)) != null) {
            typeReference = this.resolveTypeReference(genPackage, classifier, variable);
        }
        return typeReference;
    }

    private JvmTypeReference resolveTypeReference(GenPackage genPackage, EClassifier classifier, Variable variable) {
        GenClassifier genClassifier = this.findGenClassifier(genPackage, classifier);
        String className = null;
        className = !Strings.isNullOrEmpty((String)classifier.getInstanceClassName()) ? classifier.getInstanceClassName() : (genClassifier instanceof GenClass ? ((GenClass)genClassifier).getQualifiedInterfaceName() : (genClassifier instanceof GenEnum ? ((GenEnum)genClassifier).getQualifiedInstanceClassName() : String.valueOf(genPackage.getGenModel().getModelPluginPackageName()) + "." + classifier.getName()));
        JvmTypeReference typeReference = this.getTypeReferenceForTypeName(className, variable);
        if (typeReference == null) {
            Variable context = variable;
            if (variable.eContainer() instanceof PatternBody && variable.getReferences().size() > 0) {
                context = (EObject)variable.getReferences().get(0);
            }
            this.errorFeedback.reportError((EObject)context, String.format("Cannot resolve corresponding Java type for variable %s. Are the required bundle dependencies set?", variable.getName()), "org.eclipse.incquery.patternlanguage.emf.inferrer.invalid.typeref", Severity.WARNING, "org.eclipse.incquery.tooling.core.generator.marker.inference");
        }
        return typeReference;
    }

    private GenClassifier findGenClassifier(GenPackage genPackage, EClassifier classifier) {
        for (GenClassifier genClassifier : genPackage.getGenClassifiers()) {
            if (!classifier.equals(genClassifier.getEcoreClassifier())) continue;
            return genClassifier;
        }
        return null;
    }

    private JvmTypeReference getTypeReferenceForTypeName(String typeName, Variable variable) {
        JvmTypeReference typeRef = this.typeReferences.getTypeForName(typeName, (Notifier)variable, new JvmTypeReference[0]);
        return this.primitives.asWrapperTypeIfPrimitive(typeRef);
    }
}

