/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.querybasedfeatures.tooling;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ClassType;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.BoolValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.Type;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.incquery.querybasedfeatures.tooling.DerivedFeatureSourceCodeUtil;
import org.eclipse.incquery.querybasedfeatures.tooling.ProjectLocator;
import org.eclipse.incquery.tooling.core.generator.ExtensionGenerator;
import org.eclipse.incquery.tooling.core.generator.builder.IErrorFeedback;
import org.eclipse.incquery.tooling.core.generator.fragments.IGenerationFragment;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class DerivedFeatureGenerator
implements IGenerationFragment {
    @Inject
    private IEiqGenmodelProvider provider;
    @Inject
    @Extension
    private DerivedFeatureSourceCodeUtil _derivedFeatureSourceCodeUtil;
    @Inject
    private Logger logger;
    @Inject
    private IErrorFeedback errorFeedback;
    private static String annotationLiteral = "QueryBasedFeature";
    private static String DERIVED_EXTENSION_POINT = "org.eclipse.incquery.runtime.base.wellbehaving.derived.features";
    private static String IMPORT_QUALIFIER = "org.eclipse.incquery.querybasedfeatures.runtime";
    private static String FEATUREKIND_IMPORT = "QueryBasedFeatureKind";
    private static String HELPER_IMPORT = "QueryBasedFeatureHelper";
    private static String HANDLER_NAME = "IQueryBasedFeatureHandler";
    private static String HANDLER_FIELD_SUFFIX = "Handler";
    private static String DERIVED_ERROR_CODE = "org.eclipse.incquery.runtime.querybasedfeature.error";
    private static String DERIVED_EXTENSION_PREFIX = "extension.derived.";
    private static Map<String, QueryBasedFeatureKind> kinds = new Functions.Function0<Map<String, QueryBasedFeatureKind>>(){

        public Map<String, QueryBasedFeatureKind> apply() {
            Pair _of = Pair.of((Object)"single", (Object)QueryBasedFeatureKind.SINGLE_REFERENCE);
            Pair _of_1 = Pair.of((Object)"many", (Object)QueryBasedFeatureKind.MANY_REFERENCE);
            Pair _of_2 = Pair.of((Object)"counter", (Object)QueryBasedFeatureKind.COUNTER);
            Pair _of_3 = Pair.of((Object)"sum", (Object)QueryBasedFeatureKind.SUM);
            Pair _of_4 = Pair.of((Object)"iteration", (Object)QueryBasedFeatureKind.ITERATION);
            HashMap _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[]{_of, _of_1, _of_2, _of_3, _of_4});
            return _newHashMap;
        }
    }.apply();

    public void generateFiles(Pattern pattern, IFileSystemAccess fsa) {
        this.processJavaFiles(pattern, true);
    }

    public void cleanUp(Pattern pattern, IFileSystemAccess fsa) {
        this.processJavaFiles(pattern, false);
    }

    private void processJavaFiles(Pattern pattern, boolean generate) {
        block18: {
            try {
                boolean _hasAnnotationLiteral = this.hasAnnotationLiteral(pattern, annotationLiteral);
                if (!_hasAnnotationLiteral) break block18;
                try {
                    List _types;
                    Document _document;
                    HashMap<String, Object> parameters = this.processDerivedFeatureAnnotation(pattern, generate);
                    Object _get = parameters.get("package");
                    GenPackage pckg = (GenPackage)_get;
                    Object _get_1 = parameters.get("source");
                    EClass source = (EClass)_get_1;
                    Object _get_2 = parameters.get("feature");
                    EStructuralFeature feature = (EStructuralFeature)_get_2;
                    final GenClass genSourceClass = this.findGenClassForSource(pckg, source, pattern);
                    GenFeature genFeature = this.findGenFeatureForFeature(genSourceClass, feature, pattern);
                    IJavaProject javaProject = this.findJavaProject(pckg);
                    boolean _equals = Objects.equal((Object)javaProject, null);
                    if (_equals) {
                        String _nSURI = pckg.getNSURI();
                        String _plus = "Model project for GenPackage " + _nSURI;
                        String _plus_1 = String.valueOf(_plus) + " not found!";
                        this.errorFeedback.reportError((EObject)pattern, _plus_1, DERIVED_ERROR_CODE, Severity.ERROR, "org.eclipse.incquery.tooling.core.generator.marker.fragment");
                        String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
                        String _plus_2 = "Derived feature pattern " + _fullyQualifiedName;
                        String _plus_3 = String.valueOf(_plus_2) + ": Model project for GenPackage ";
                        String _nSURI_1 = pckg.getNSURI();
                        String _plus_4 = String.valueOf(_plus_3) + _nSURI_1;
                        String _plus_5 = String.valueOf(_plus_4) + " not found!";
                        IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus_5);
                        throw _illegalArgumentException;
                    }
                    ICompilationUnit compunit = this.findJavaFile(pckg, genSourceClass, javaProject);
                    String docSource = compunit.getSource();
                    ASTParser parser = ASTParser.newParser((int)3);
                    Document document = _document = new Document(docSource);
                    parser.setSource(compunit);
                    ASTNode _createAST = parser.createAST(null);
                    CompilationUnit astNode = (CompilationUnit)_createAST;
                    AST ast = astNode.getAST();
                    ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                    List types = _types = astNode.types();
                    Functions.Function1<AbstractTypeDeclaration, Boolean> _function = new Functions.Function1<AbstractTypeDeclaration, Boolean>(){

                        public Boolean apply(AbstractTypeDeclaration it) {
                            boolean _equals;
                            boolean _xblockexpression = false;
                            AbstractTypeDeclaration type = it;
                            SimpleName _name = type.getName();
                            String _identifier = _name.getIdentifier();
                            String _className = genSourceClass.getClassName();
                            _xblockexpression = _equals = Objects.equal((Object)_identifier, (Object)_className);
                            return _xblockexpression;
                        }
                    };
                    AbstractTypeDeclaration _findFirst = (AbstractTypeDeclaration)IterableExtensions.findFirst((Iterable)types, (Functions.Function1)_function);
                    TypeDeclaration type = (TypeDeclaration)_findFirst;
                    ListRewrite bodyDeclListRewrite = rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
                    final EStructuralFeature feat = genFeature.getEcoreFeature();
                    if (generate) {
                        this.ensureImports(ast, rewrite, astNode, type);
                        this.ensureHandlerField(ast, bodyDeclListRewrite, type, genFeature);
                        this.ensureGetterMethod(ast, document, type, rewrite, bodyDeclListRewrite, genSourceClass, genFeature, pattern, parameters);
                        try {
                            ArrayList _arrayList;
                            EList _eAnnotations = feat.getEAnnotations();
                            ArrayList annotations = _arrayList = new ArrayList(_eAnnotations);
                            Procedures.Procedure1<EAnnotation> _function_1 = new Procedures.Procedure1<EAnnotation>(){

                                public void apply(EAnnotation it) {
                                    String _source = it.getSource();
                                    boolean _equals = Objects.equal((Object)_source, (Object)"org.eclipse.incquery.querybasedfeature");
                                    if (_equals) {
                                        EList _eAnnotations = feat.getEAnnotations();
                                        _eAnnotations.remove((Object)it);
                                    }
                                }
                            };
                            IterableExtensions.forEach(annotations, (Procedures.Procedure1)_function_1);
                            EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                            annotation.setSource("org.eclipse.incquery.querybasedfeature");
                            EList _eAnnotations_1 = feat.getEAnnotations();
                            _eAnnotations_1.add((Object)annotation);
                            EClass _eStringToStringMapEntry = EcorePackage.eINSTANCE.getEStringToStringMapEntry();
                            EObject _create = EcoreFactory.eINSTANCE.create(_eStringToStringMapEntry);
                            BasicEMap.Entry entry = (BasicEMap.Entry)_create;
                            entry.setKey((Object)"patternFQN");
                            String _fullyQualifiedName_1 = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
                            entry.setValue((Object)_fullyQualifiedName_1);
                            EMap _details = annotation.getDetails();
                            _details.add((Object)entry);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Exception) {
                                Exception e = (Exception)_t;
                                this.logger.warn((Object)"Error happened when trying to edit Ecore file!", (Throwable)e);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    } else {
                        String _name = genFeature.getName();
                        this.removeHandlerField(ast, bodyDeclListRewrite, type, _name);
                        this.restoreGetterMethod(ast, document, compunit, type, rewrite, bodyDeclListRewrite, genSourceClass, genFeature);
                        try {
                            ArrayList _arrayList_1;
                            EList _eAnnotations_2 = feat.getEAnnotations();
                            ArrayList annotations_1 = _arrayList_1 = new ArrayList(_eAnnotations_2);
                            Procedures.Procedure1<EAnnotation> _function_2 = new Procedures.Procedure1<EAnnotation>(){

                                public void apply(EAnnotation it) {
                                    String _source = it.getSource();
                                    boolean _equals = Objects.equal((Object)_source, (Object)"org.eclipse.incquery.querybasedfeature");
                                    if (_equals) {
                                        EList _eAnnotations = feat.getEAnnotations();
                                        _eAnnotations.remove((Object)it);
                                    }
                                }
                            };
                            IterableExtensions.forEach(annotations_1, (Procedures.Procedure1)_function_2);
                        }
                        catch (Throwable _t_1) {
                            if (_t_1 instanceof Exception) {
                                Exception e_1 = (Exception)_t_1;
                                this.logger.warn((Object)"Error happened when trying to edit Ecore file!", (Throwable)e_1);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_1);
                        }
                    }
                    try {
                        Resource _eResource = feat.eResource();
                        _eResource.save(null);
                    }
                    catch (Throwable _t_2) {
                        if (_t_2 instanceof IOException) {
                            IOException e_2 = (IOException)_t_2;
                            this.logger.warn((Object)"Error happened when trying to save Ecore file!", (Throwable)e_2);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_2);
                    }
                    Map _options = javaProject.getOptions(true);
                    TextEdit edits = rewrite.rewriteAST((IDocument)document, _options);
                    edits.apply((IDocument)document);
                    String newSource = document.get();
                    IBuffer _buffer = compunit.getBuffer();
                    _buffer.setContents(newSource);
                    IBuffer _buffer_1 = compunit.getBuffer();
                    _buffer_1.save(null, false);
                }
                catch (Throwable _t_3) {
                    if (_t_3 instanceof IllegalArgumentException) {
                        IllegalArgumentException e_3 = (IllegalArgumentException)_t_3;
                        if (generate) {
                            String _message = e_3.getMessage();
                            this.logger.error((Object)_message, (Throwable)e_3);
                        }
                        break block18;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t_3);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    private GenClass findGenClassForSource(GenPackage pckg, final EClass source, Pattern pattern) {
        Functions.Function1<GenClass, Boolean> _function;
        EList _genClasses = pckg.getGenClasses();
        GenClass genSourceClass = (GenClass)IterableExtensions.findFirst((Iterable)_genClasses, (Functions.Function1)(_function = new Functions.Function1<GenClass, Boolean>(){

            public Boolean apply(GenClass it) {
                boolean _equals;
                boolean _xblockexpression = false;
                EClass cls = it.getEcoreClass();
                String _name = cls.getName();
                String _name_1 = source.getName();
                _xblockexpression = _equals = Objects.equal((Object)_name, (Object)_name_1);
                return _xblockexpression;
            }
        }));
        boolean _equals = Objects.equal((Object)genSourceClass, null);
        if (_equals) {
            String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
            String _plus = "Derived feature pattern " + _fullyQualifiedName;
            String _plus_1 = String.valueOf(_plus) + ": Source EClass ";
            String _name = source.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name;
            String _plus_3 = String.valueOf(_plus_2) + " not found in GenPackage ";
            String _plus_4 = String.valueOf(_plus_3) + pckg;
            String _plus_5 = String.valueOf(_plus_4) + "!";
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus_5);
            throw _illegalArgumentException;
        }
        return genSourceClass;
    }

    private GenFeature findGenFeatureForFeature(GenClass genSourceClass, final EStructuralFeature feature, Pattern pattern) {
        Functions.Function1<GenFeature, Boolean> _function;
        EList _genFeatures = genSourceClass.getGenFeatures();
        GenFeature genFeature = (GenFeature)IterableExtensions.findFirst((Iterable)_genFeatures, (Functions.Function1)(_function = new Functions.Function1<GenFeature, Boolean>(){

            public Boolean apply(GenFeature it) {
                boolean _equals;
                boolean _xblockexpression = false;
                EStructuralFeature feat = it.getEcoreFeature();
                String _name = feat.getName();
                String _name_1 = feature.getName();
                _xblockexpression = _equals = Objects.equal((Object)_name, (Object)_name_1);
                return _xblockexpression;
            }
        }));
        boolean _equals = Objects.equal((Object)genFeature, null);
        if (_equals) {
            String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
            String _plus = "Derived feature pattern " + _fullyQualifiedName;
            String _plus_1 = String.valueOf(_plus) + ": Feature ";
            String _name = feature.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name;
            String _plus_3 = String.valueOf(_plus_2) + " not found in GenClass ";
            String _name_1 = genSourceClass.getName();
            String _plus_4 = String.valueOf(_plus_3) + _name_1;
            String _plus_5 = String.valueOf(_plus_4) + "!";
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus_5);
            throw _illegalArgumentException;
        }
        return genFeature;
    }

    private IJavaProject findJavaProject(GenPackage pckg) {
        IJavaProject _locateProject;
        IJavaProject _xblockexpression = null;
        GenModel _genModel = pckg.getGenModel();
        String projectDir = _genModel.getModelProjectDirectory();
        _xblockexpression = _locateProject = ProjectLocator.locateProject(projectDir, this.logger);
        return _xblockexpression;
    }

    private ICompilationUnit findJavaFile(GenPackage pckg, final GenClass genSourceClass, IJavaProject javaProject) {
        try {
            ICompilationUnit _findFirst;
            boolean _notEquals_5;
            boolean _notEquals_2;
            boolean _notEquals;
            ICompilationUnit _xblockexpression = null;
            EPackage _ecorePackage = pckg.getEcorePackage();
            String prefix = _ecorePackage.getName();
            String suffix = pckg.getClassPackageSuffix();
            String base = pckg.getBasePackage();
            String packageNameTmp = "";
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)base, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _notEquals_1 = !Objects.equal((Object)base, (Object)"");
                boolean bl2 = _and = _notEquals && _notEquals_1;
            }
            if (_and) {
                packageNameTmp = base;
            }
            boolean _and_1 = false;
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)prefix, null);
            if (!_notEquals_2) {
                _and_1 = false;
            } else {
                boolean _notEquals_3 = !Objects.equal((Object)prefix, (Object)"");
                boolean bl4 = _and_1 = _notEquals_2 && _notEquals_3;
            }
            if (_and_1) {
                boolean _notEquals_4;
                boolean bl5 = _notEquals_4 = !Objects.equal((Object)packageNameTmp, (Object)"");
                if (_notEquals_4) {
                    String _plus_1;
                    String _plus = String.valueOf(packageNameTmp) + ".";
                    packageNameTmp = _plus_1 = String.valueOf(_plus) + prefix;
                } else {
                    packageNameTmp = prefix;
                }
            }
            boolean _and_2 = false;
            boolean bl6 = _notEquals_5 = !Objects.equal((Object)suffix, null);
            if (!_notEquals_5) {
                _and_2 = false;
            } else {
                boolean _notEquals_6 = !Objects.equal((Object)suffix, (Object)"");
                boolean bl7 = _and_2 = _notEquals_5 && _notEquals_6;
            }
            if (_and_2) {
                boolean _notEquals_7;
                boolean bl8 = _notEquals_7 = !Objects.equal((Object)packageNameTmp, (Object)"");
                if (_notEquals_7) {
                    String _plus_3;
                    String _plus_2 = String.valueOf(packageNameTmp) + ".";
                    packageNameTmp = _plus_3 = String.valueOf(_plus_2) + suffix;
                } else {
                    packageNameTmp = suffix;
                }
            }
            final String packageName = packageNameTmp;
            IPackageFragment[] _packageFragments = javaProject.getPackageFragments();
            Functions.Function1<IPackageFragment, Boolean> _function = new Functions.Function1<IPackageFragment, Boolean>(){

                public Boolean apply(IPackageFragment it) {
                    String _elementName = it.getElementName();
                    boolean _equals = Objects.equal((Object)_elementName, (Object)packageName);
                    return _equals;
                }
            };
            IPackageFragment implPackage = (IPackageFragment)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_packageFragments)), (Functions.Function1)_function);
            boolean _equals = Objects.equal((Object)implPackage, null);
            if (_equals) {
                String _plus_4 = "Derived feature generation: Implementation package " + packageName;
                String _plus_5 = String.valueOf(_plus_4) + " not found!";
                IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus_5);
                throw _illegalArgumentException;
            }
            ICompilationUnit[] _compilationUnits = implPackage.getCompilationUnits();
            Functions.Function1<ICompilationUnit, Boolean> _function_1 = new Functions.Function1<ICompilationUnit, Boolean>(){

                public Boolean apply(ICompilationUnit it) {
                    String _elementName = it.getElementName();
                    String _className = genSourceClass.getClassName();
                    String _plus = String.valueOf(_className) + ".java";
                    boolean _equals = Objects.equal((Object)_elementName, (Object)_plus);
                    return _equals;
                }
            };
            _xblockexpression = _findFirst = (ICompilationUnit)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_compilationUnits)), (Functions.Function1)_function_1);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void ensureImports(AST ast, ASTRewrite rewrite, CompilationUnit astNode, TypeDeclaration type) {
        Functions.Function1<ImportDeclaration, Boolean> _function_2;
        ImportDeclaration helperImport;
        boolean _equals_2;
        Functions.Function1<ImportDeclaration, Boolean> _function_1;
        ImportDeclaration kindImport;
        boolean _equals_1;
        Functions.Function1<ImportDeclaration, Boolean> _function;
        ListRewrite importListRewrite = rewrite.getListRewrite((ASTNode)astNode, CompilationUnit.IMPORTS_PROPERTY);
        List _imports = astNode.imports();
        List imports = _imports;
        ImportDeclaration handlerImport = (ImportDeclaration)IterableExtensions.findFirst((Iterable)imports, (Functions.Function1)(_function = new Functions.Function1<ImportDeclaration, Boolean>(){

            public Boolean apply(ImportDeclaration it) {
                Name _name = it.getName();
                String _fullyQualifiedName = _name.getFullyQualifiedName();
                String _plus = String.valueOf(IMPORT_QUALIFIER) + ".";
                String _plus_1 = String.valueOf(_plus) + HANDLER_NAME;
                boolean _equals = Objects.equal((Object)_fullyQualifiedName, (Object)_plus_1);
                return _equals;
            }
        }));
        boolean _equals = Objects.equal((Object)handlerImport, null);
        if (_equals) {
            ImportDeclaration handlerImportNew = ast.newImportDeclaration();
            Name _newName = ast.newName(IMPORT_QUALIFIER);
            SimpleName _newSimpleName = ast.newSimpleName(HANDLER_NAME);
            QualifiedName _newQualifiedName = ast.newQualifiedName(_newName, _newSimpleName);
            handlerImportNew.setName((Name)_newQualifiedName);
            importListRewrite.insertLast((ASTNode)handlerImportNew, null);
        }
        if (_equals_1 = Objects.equal((Object)(kindImport = (ImportDeclaration)IterableExtensions.findFirst((Iterable)imports, (Functions.Function1)(_function_1 = new Functions.Function1<ImportDeclaration, Boolean>(){

            public Boolean apply(ImportDeclaration it) {
                Name _name = it.getName();
                String _fullyQualifiedName = _name.getFullyQualifiedName();
                String _plus = String.valueOf(IMPORT_QUALIFIER) + ".";
                String _plus_1 = String.valueOf(_plus) + FEATUREKIND_IMPORT;
                boolean _equals = Objects.equal((Object)_fullyQualifiedName, (Object)_plus_1);
                return _equals;
            }
        }))), null)) {
            ImportDeclaration kindImportNew = ast.newImportDeclaration();
            Name _newName_1 = ast.newName(IMPORT_QUALIFIER);
            SimpleName _newSimpleName_1 = ast.newSimpleName(FEATUREKIND_IMPORT);
            QualifiedName _newQualifiedName_1 = ast.newQualifiedName(_newName_1, _newSimpleName_1);
            kindImportNew.setName((Name)_newQualifiedName_1);
            importListRewrite.insertLast((ASTNode)kindImportNew, null);
        }
        if (_equals_2 = Objects.equal((Object)(helperImport = (ImportDeclaration)IterableExtensions.findFirst((Iterable)imports, (Functions.Function1)(_function_2 = new Functions.Function1<ImportDeclaration, Boolean>(){

            public Boolean apply(ImportDeclaration it) {
                Name _name = it.getName();
                String _fullyQualifiedName = _name.getFullyQualifiedName();
                String _plus = String.valueOf(IMPORT_QUALIFIER) + ".";
                String _plus_1 = String.valueOf(_plus) + HELPER_IMPORT;
                boolean _equals = Objects.equal((Object)_fullyQualifiedName, (Object)_plus_1);
                return _equals;
            }
        }))), null)) {
            ImportDeclaration helperImportNew = ast.newImportDeclaration();
            Name _newName_2 = ast.newName(IMPORT_QUALIFIER);
            SimpleName _newSimpleName_2 = ast.newSimpleName(HELPER_IMPORT);
            QualifiedName _newQualifiedName_2 = ast.newQualifiedName(_newName_2, _newSimpleName_2);
            helperImportNew.setName((Name)_newQualifiedName_2);
            importListRewrite.insertLast((ASTNode)helperImportNew, null);
        }
    }

    private void ensureHandlerField(AST ast, ListRewrite bodyDeclListRewrite, TypeDeclaration type, final GenFeature feature) {
        FieldDeclaration[] _fields = type.getFields();
        Functions.Function1<FieldDeclaration, Boolean> _function = new Functions.Function1<FieldDeclaration, Boolean>(){

            public Boolean apply(FieldDeclaration it) {
                boolean _exists;
                List _fragments;
                boolean _xblockexpression = false;
                List fragments = _fragments = it.fragments();
                Functions.Function1<VariableDeclarationFragment, Boolean> _function = new Functions.Function1<VariableDeclarationFragment, Boolean>(){

                    public Boolean apply(VariableDeclarationFragment it) {
                        SimpleName _name = it.getName();
                        String _identifier = _name.getIdentifier();
                        String _name_1 = feature.getName();
                        String _plus = String.valueOf(_name_1) + HANDLER_FIELD_SUFFIX;
                        boolean _equals = Objects.equal((Object)_identifier, (Object)_plus);
                        return _equals;
                    }
                };
                _xblockexpression = _exists = IterableExtensions.exists((Iterable)fragments, (Functions.Function1)_function);
                return _xblockexpression;
            }
        };
        FieldDeclaration handler = (FieldDeclaration)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_fields)), (Functions.Function1)_function);
        boolean _equals = Objects.equal((Object)handler, null);
        if (_equals) {
            VariableDeclarationFragment handlerFragment = ast.newVariableDeclarationFragment();
            String _name = feature.getName();
            String _plus = String.valueOf(_name) + HANDLER_FIELD_SUFFIX;
            SimpleName _newSimpleName = ast.newSimpleName(_plus);
            handlerFragment.setName(_newSimpleName);
            FieldDeclaration handlerField = ast.newFieldDeclaration(handlerFragment);
            SimpleName _newSimpleName_1 = ast.newSimpleName(HANDLER_NAME);
            SimpleType handlerType = ast.newSimpleType((Name)_newSimpleName_1);
            handlerField.setType((org.eclipse.jdt.core.dom.Type)handlerType);
            List _modifiers = handlerField.modifiers();
            Modifier _newModifier = ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
            _modifiers.add(_newModifier);
            TagElement handlerTag = ast.newTagElement();
            TextElement tagText = ast.newTextElement();
            String _name_1 = feature.getName();
            String _plus_1 = "EMF-IncQuery handler for query-based feature " + _name_1;
            tagText.setText(_plus_1);
            List _fragments = handlerTag.fragments();
            _fragments.add(tagText);
            Javadoc javaDoc = ast.newJavadoc();
            List _tags = javaDoc.tags();
            _tags.add(handlerTag);
            handlerField.setJavadoc(javaDoc);
            bodyDeclListRewrite.insertLast((ASTNode)handlerField, null);
        }
    }

    private void removeHandlerField(AST ast, ListRewrite bodyDeclListRewrite, TypeDeclaration type, final String featureName) {
        boolean _notEquals;
        FieldDeclaration[] _fields = type.getFields();
        Functions.Function1<FieldDeclaration, Boolean> _function = new Functions.Function1<FieldDeclaration, Boolean>(){

            public Boolean apply(FieldDeclaration it) {
                boolean _exists;
                List _fragments;
                boolean _xblockexpression = false;
                List fragments = _fragments = it.fragments();
                Functions.Function1<VariableDeclarationFragment, Boolean> _function = new Functions.Function1<VariableDeclarationFragment, Boolean>(){

                    public Boolean apply(VariableDeclarationFragment it) {
                        SimpleName _name = it.getName();
                        String _identifier = _name.getIdentifier();
                        String _plus = String.valueOf(featureName) + HANDLER_FIELD_SUFFIX;
                        boolean _equals = Objects.equal((Object)_identifier, (Object)_plus);
                        return _equals;
                    }
                };
                _xblockexpression = _exists = IterableExtensions.exists((Iterable)fragments, (Functions.Function1)_function);
                return _xblockexpression;
            }
        };
        FieldDeclaration handler = (FieldDeclaration)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_fields)), (Functions.Function1)_function);
        boolean bl = _notEquals = !Objects.equal((Object)handler, null);
        if (_notEquals) {
            bodyDeclListRewrite.remove((ASTNode)handler, null);
        }
    }

    private void ensureGetterMethod(AST ast, Document document, TypeDeclaration type, ASTRewrite rewrite, ListRewrite bodyDeclListRewrite, GenClass sourceClass, GenFeature genFeature, Pattern pattern, Map<String, Object> parameters) {
        boolean _notEquals;
        Object _get = parameters.get("sourceVar");
        String sourceName = (String)_get;
        Object _get_1 = parameters.get("targetVar");
        String targetName = (String)_get_1;
        Object _get_2 = parameters.get("kind");
        QueryBasedFeatureKind kind = (QueryBasedFeatureKind)_get_2;
        Object _get_3 = parameters.get("keepCache");
        Boolean keepCache = (Boolean)_get_3;
        MethodDeclaration getMethod = this.findFeatureMethod(type, genFeature, "");
        MethodDeclaration getGenMethod = this.findFeatureMethod(type, genFeature, "Gen");
        CharSequence methodSource = this._derivedFeatureSourceCodeUtil.methodBody(sourceClass, genFeature, pattern, sourceName, targetName, kind, keepCache);
        String _string = methodSource.toString();
        MethodDeclaration dummyMethod = this.processDummyComputationUnit(_string);
        boolean bl = _notEquals = !Objects.equal((Object)getMethod, null);
        if (_notEquals) {
            boolean _not;
            boolean _notEquals_1;
            Javadoc javadoc = getMethod.getJavadoc();
            boolean generatedBody = false;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)javadoc, null);
            if (_notEquals_1) {
                boolean _notEquals_3;
                List _tags;
                List tags = _tags = javadoc.tags();
                Functions.Function1<TagElement, Boolean> _function = new Functions.Function1<TagElement, Boolean>(){

                    public Boolean apply(TagElement it) {
                        String _tagName = it.getTagName();
                        boolean _equals = Objects.equal((Object)_tagName, (Object)"@generated");
                        return _equals;
                    }
                };
                TagElement generatedTag = (TagElement)IterableExtensions.findFirst((Iterable)tags, (Functions.Function1)_function);
                Functions.Function1<TagElement, Boolean> _function_1 = new Functions.Function1<TagElement, Boolean>(){

                    public Boolean apply(TagElement it) {
                        String _tagName = it.getTagName();
                        boolean _equals = Objects.equal((Object)_tagName, (Object)"@query-based");
                        return _equals;
                    }
                };
                TagElement derivedTag = (TagElement)IterableExtensions.findFirst((Iterable)tags, (Functions.Function1)_function_1);
                boolean _and = false;
                boolean _and_1 = false;
                boolean _equals = Objects.equal((Object)derivedTag, null);
                if (!_equals) {
                    _and_1 = false;
                } else {
                    boolean _notEquals_2 = !Objects.equal((Object)generatedTag, null);
                    boolean bl3 = _and_1 = _equals && _notEquals_2;
                }
                if (!_and_1) {
                    _and = false;
                } else {
                    List _fragments = generatedTag.fragments();
                    int _size = _fragments.size();
                    boolean _equals_1 = _size == 0;
                    boolean bl4 = _and = _and_1 && _equals_1;
                }
                if (_and) {
                    List _tags_1;
                    generatedBody = true;
                    SimpleName _name = getMethod.getName();
                    String methodName = _name.getIdentifier();
                    ASTNode _copySubtree = ASTNode.copySubtree((AST)ast, (ASTNode)getMethod);
                    MethodDeclaration method = (MethodDeclaration)_copySubtree;
                    SimpleName _name_1 = method.getName();
                    SimpleName _newSimpleName = ast.newSimpleName(methodName);
                    rewrite.replace((ASTNode)_name_1, (ASTNode)_newSimpleName, null);
                    Block _body = method.getBody();
                    Block _body_1 = dummyMethod.getBody();
                    rewrite.replace((ASTNode)_body, (ASTNode)_body_1, null);
                    Javadoc _javadoc = method.getJavadoc();
                    List methodtags = _tags_1 = _javadoc.tags();
                    Functions.Function1<TagElement, Boolean> _function_2 = new Functions.Function1<TagElement, Boolean>(){

                        public Boolean apply(TagElement it) {
                            String _tagName = it.getTagName();
                            boolean _equals = Objects.equal((Object)_tagName, (Object)"@generated");
                            return _equals;
                        }
                    };
                    TagElement oldTag = (TagElement)IterableExtensions.findFirst((Iterable)methodtags, (Functions.Function1)_function_2);
                    rewrite.set((ASTNode)oldTag, (StructuralPropertyDescriptor)TagElement.TAG_NAME_PROPERTY, (Object)"@query-based", null);
                    ListRewrite tagsRewrite = rewrite.getListRewrite((ASTNode)oldTag, TagElement.FRAGMENTS_PROPERTY);
                    TextElement tagText = ast.newTextElement();
                    String _name_2 = genFeature.getName();
                    String _plus = "getter created by EMF-IncQuery for query-based feature " + _name_2;
                    tagText.setText(_plus);
                    tagsRewrite.insertLast((ASTNode)tagText, null);
                    bodyDeclListRewrite.insertLast((ASTNode)method, null);
                    boolean _equals_2 = Objects.equal((Object)getGenMethod, null);
                    if (_equals_2) {
                        SimpleName _name_3 = getMethod.getName();
                        SimpleName _name_4 = getMethod.getName();
                        String _identifier = _name_4.getIdentifier();
                        String _plus_1 = String.valueOf(_identifier) + "Gen";
                        SimpleName _newSimpleName_1 = ast.newSimpleName(_plus_1);
                        rewrite.replace((ASTNode)_name_3, (ASTNode)_newSimpleName_1, null);
                    } else {
                        SimpleName _name_5 = getMethod.getName();
                        SimpleName _name_6 = getMethod.getName();
                        String _identifier_1 = _name_6.getIdentifier();
                        String _plus_2 = "_" + _identifier_1;
                        SimpleName _newSimpleName_2 = ast.newSimpleName(_plus_2);
                        rewrite.replace((ASTNode)_name_5, (ASTNode)_newSimpleName_2, null);
                    }
                }
                boolean bl5 = _notEquals_3 = !Objects.equal((Object)derivedTag, null);
                if (_notEquals_3) {
                    generatedBody = true;
                    Block _body_2 = getMethod.getBody();
                    Block _body_3 = dummyMethod.getBody();
                    this.replaceMethodBody(ast, rewrite, _body_2, _body_3, javadoc, document, false, null, null, null);
                }
            }
            boolean bl6 = _not = !generatedBody;
            if (_not) {
                Block _body_4 = getMethod.getBody();
                Block _body_5 = dummyMethod.getBody();
                String _name_7 = genFeature.getName();
                String _plus_3 = "getter created by EMF-IncQuery for query-based feature " + _name_7;
                this.replaceMethodBody(ast, rewrite, _body_4, _body_5, javadoc, document, true, "@query-based", _plus_3, null);
            }
        }
    }

    private void restoreGetterMethod(AST ast, Document document, ICompilationUnit compunit, TypeDeclaration type, ASTRewrite rewrite, ListRewrite bodyDeclListRewrite, GenClass sourceClass, GenFeature genFeature) {
        boolean _notEquals;
        MethodDeclaration getMethod = this.findFeatureMethod(type, genFeature, "");
        MethodDeclaration getGenMethod = this.findFeatureMethod(type, genFeature, "Gen");
        boolean bl = _notEquals = !Objects.equal((Object)getGenMethod, null);
        if (_notEquals) {
            boolean _notEquals_1;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)getMethod, null);
            if (_notEquals_1) {
                SimpleName _name = getGenMethod.getName();
                SimpleName _name_1 = getMethod.getName();
                String _identifier = _name_1.getIdentifier();
                SimpleName _newSimpleName = ast.newSimpleName(_identifier);
                rewrite.replace((ASTNode)_name, (ASTNode)_newSimpleName, null);
                bodyDeclListRewrite.remove((ASTNode)getMethod, null);
            }
        } else {
            boolean _notEquals_2;
            EStructuralFeature _ecoreFeature = genFeature.getEcoreFeature();
            boolean _isMany = _ecoreFeature.isMany();
            CharSequence methodSource = this._derivedFeatureSourceCodeUtil.defaultMethod(_isMany);
            String _string = methodSource.toString();
            MethodDeclaration dummyMethod = this.processDummyComputationUnit(_string);
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)getMethod, null);
            if (_notEquals_2) {
                boolean _notEquals_3;
                Javadoc javadoc = getMethod.getJavadoc();
                boolean bl4 = _notEquals_3 = !Objects.equal((Object)javadoc, null);
                if (_notEquals_3) {
                    boolean _notEquals_8;
                    boolean _notEquals_5;
                    boolean _notEquals_4;
                    List _tags;
                    List tags = _tags = javadoc.tags();
                    Functions.Function1<TagElement, Boolean> _function = new Functions.Function1<TagElement, Boolean>(){

                        public Boolean apply(TagElement it) {
                            String _tagName = it.getTagName();
                            boolean _equals = Objects.equal((Object)_tagName, (Object)"@query-basedd");
                            return _equals;
                        }
                    };
                    TagElement derivedTag = (TagElement)IterableExtensions.findFirst((Iterable)tags, (Functions.Function1)_function);
                    Functions.Function1<TagElement, Boolean> _function_1 = new Functions.Function1<TagElement, Boolean>(){

                        public Boolean apply(TagElement it) {
                            String _tagName = it.getTagName();
                            boolean _equals = Objects.equal((Object)_tagName, (Object)"@original");
                            return _equals;
                        }
                    };
                    TagElement originalTag = (TagElement)IterableExtensions.findFirst((Iterable)tags, (Functions.Function1)_function_1);
                    Functions.Function1<TagElement, Boolean> _function_2 = new Functions.Function1<TagElement, Boolean>(){

                        public Boolean apply(TagElement it) {
                            String _tagName = it.getTagName();
                            boolean _equals = Objects.equal((Object)_tagName, (Object)"@generated");
                            return _equals;
                        }
                    };
                    TagElement generatedTag = (TagElement)IterableExtensions.findFirst((Iterable)tags, (Functions.Function1)_function_2);
                    boolean _and = false;
                    boolean bl5 = _notEquals_4 = !Objects.equal((Object)generatedTag, null);
                    if (!_notEquals_4) {
                        _and = false;
                    } else {
                        List _fragments = generatedTag.fragments();
                        int _size = _fragments.size();
                        boolean _equals = _size == 0;
                        boolean bl6 = _and = _notEquals_4 && _equals;
                    }
                    if (_and) {
                        return;
                    }
                    boolean _and_1 = false;
                    boolean bl7 = _notEquals_5 = !Objects.equal((Object)derivedTag, null);
                    if (!_notEquals_5) {
                        _and_1 = false;
                    } else {
                        boolean _notEquals_6 = !Objects.equal((Object)originalTag, null);
                        boolean bl8 = _and_1 = _notEquals_5 && _notEquals_6;
                    }
                    if (_and_1) {
                        boolean _notEquals_7;
                        List _fragments_1 = originalTag.fragments();
                        int _size_1 = _fragments_1.size();
                        boolean bl9 = _notEquals_7 = _size_1 != 0;
                        if (_notEquals_7) {
                            StringBuilder _stringBuilder;
                            ListRewrite tagsRewrite = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
                            tagsRewrite.remove((ASTNode)derivedTag, null);
                            List tagFragments = originalTag.fragments();
                            StringBuilder oldBody = _stringBuilder = new StringBuilder();
                            for (Object o : tagFragments) {
                                if (!(o instanceof TextElement)) continue;
                                String _text = ((TextElement)o).getText();
                                oldBody.append(_text);
                            }
                            MethodDeclaration oldMethod = this.prepareOriginalMethod(compunit, type, getMethod, oldBody);
                            Block _body = getMethod.getBody();
                            Block _body_1 = oldMethod.getBody();
                            rewrite.replace((ASTNode)_body, (ASTNode)_body_1, null);
                            tagsRewrite.remove((ASTNode)originalTag, null);
                            return;
                        }
                    }
                    boolean bl10 = _notEquals_8 = !Objects.equal((Object)generatedTag, null);
                    if (_notEquals_8) {
                        return;
                    }
                }
                Block _body_2 = getMethod.getBody();
                Block _body_3 = dummyMethod.getBody();
                this.replaceMethodBody(ast, rewrite, _body_2, _body_3, javadoc, document, false, "@generated", "", "@query-based");
            }
        }
    }

    private MethodDeclaration findFeatureMethod(TypeDeclaration type, final GenFeature genFeature, final String suffix) {
        MethodDeclaration[] _methods = type.getMethods();
        Functions.Function1<MethodDeclaration, Boolean> _function = new Functions.Function1<MethodDeclaration, Boolean>(){

            public Boolean apply(MethodDeclaration it) {
                boolean _xifexpression = false;
                boolean _isBasicGet = genFeature.isBasicGet();
                if (_isBasicGet) {
                    boolean _equals;
                    SimpleName _name = it.getName();
                    String _identifier = _name.getIdentifier();
                    String _getAccessor = genFeature.getGetAccessor();
                    String _firstUpper = StringExtensions.toFirstUpper((String)_getAccessor);
                    String _plus = "basic" + _firstUpper;
                    String _plus_1 = String.valueOf(_plus) + suffix;
                    _xifexpression = _equals = Objects.equal((Object)_identifier, (Object)_plus_1);
                } else {
                    boolean _equals_1;
                    SimpleName _name_1 = it.getName();
                    String _identifier_1 = _name_1.getIdentifier();
                    String _getAccessor_1 = genFeature.getGetAccessor();
                    String _plus_2 = String.valueOf(_getAccessor_1) + suffix;
                    _xifexpression = _equals_1 = Objects.equal((Object)_identifier_1, (Object)_plus_2);
                }
                return _xifexpression;
            }
        };
        MethodDeclaration _findFirst = (MethodDeclaration)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_methods)), (Functions.Function1)_function);
        return _findFirst;
    }

    private MethodDeclaration processDummyComputationUnit(String dummySource) {
        MethodDeclaration _get_1;
        MethodDeclaration _xblockexpression = null;
        ASTParser methodBodyParser = ASTParser.newParser((int)3);
        char[] _charArray = dummySource.toCharArray();
        methodBodyParser.setSource(_charArray);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.5", (Map)options);
        methodBodyParser.setCompilerOptions((Map)options);
        ASTNode dummyAST = methodBodyParser.createAST(null);
        CompilationUnit dummyCU = (CompilationUnit)dummyAST;
        List _types = dummyCU.types();
        Object _get = _types.get(0);
        TypeDeclaration dummyType = (TypeDeclaration)_get;
        MethodDeclaration[] _methods = dummyType.getMethods();
        _xblockexpression = _get_1 = _methods[0];
        return _xblockexpression;
    }

    private MethodDeclaration prepareOriginalMethod(ICompilationUnit cu, TypeDeclaration type, MethodDeclaration method, final StringBuilder originalBody) {
        try {
            MethodDeclaration _processDummyComputationUnit;
            MethodDeclaration _xblockexpression = null;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"public class Dummy{public void DummyMethod()");
            originalBody.insert(0, (CharSequence)_builder);
            IImportDeclaration[] _imports = cu.getImports();
            Procedures.Procedure1<IImportDeclaration> _function = new Procedures.Procedure1<IImportDeclaration>(){

                public void apply(IImportDeclaration it) {
                    try {
                        String _source = it.getSource();
                        String _plus = String.valueOf(_source) + "\n";
                        originalBody.insert(0, _plus);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)_imports)), (Procedures.Procedure1)_function);
            originalBody.append("}");
            String dummyCU = originalBody.toString();
            _xblockexpression = _processDummyComputationUnit = this.processDummyComputationUnit(dummyCU);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void replaceMethodBody(AST ast, ASTRewrite rewrite, Block oldBody, Block newBody, Javadoc javadoc, Document document, boolean keepOld, final String newTagName, String newTagText, final String removeTagName) {
        boolean _equals_1;
        boolean _equals;
        boolean _notEquals;
        List _tags;
        List tags = _tags = javadoc.tags();
        ListRewrite tagsRewrite = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
        Functions.Function1<TagElement, Boolean> _function = new Functions.Function1<TagElement, Boolean>(){

            public Boolean apply(TagElement it) {
                String _tagName = it.getTagName();
                boolean _equals = Objects.equal((Object)_tagName, (Object)"@original");
                return _equals;
            }
        };
        TagElement originalTag = (TagElement)IterableExtensions.findFirst((Iterable)tags, (Functions.Function1)_function);
        Functions.Function1<TagElement, Boolean> _function_1 = new Functions.Function1<TagElement, Boolean>(){

            public Boolean apply(TagElement it) {
                String _tagName = it.getTagName();
                boolean _equals = Objects.equal((Object)_tagName, (Object)newTagName);
                return _equals;
            }
        };
        TagElement newTag = (TagElement)IterableExtensions.findFirst((Iterable)tags, (Functions.Function1)_function_1);
        boolean bl = _notEquals = !Objects.equal((Object)removeTagName, null);
        if (_notEquals) {
            boolean _notEquals_1;
            Functions.Function1<TagElement, Boolean> _function_2 = new Functions.Function1<TagElement, Boolean>(){

                public Boolean apply(TagElement it) {
                    String _tagName = it.getTagName();
                    boolean _equals = Objects.equal((Object)_tagName, (Object)removeTagName);
                    return _equals;
                }
            };
            TagElement removeTag = (TagElement)IterableExtensions.findFirst((Iterable)tags, (Functions.Function1)_function_2);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)removeTag, null);
            if (_notEquals_1) {
                tagsRewrite.remove((ASTNode)removeTag, null);
            }
        }
        if (_equals = Objects.equal((Object)originalTag, null)) {
            if (keepOld) {
                TagElement tag = ast.newTagElement();
                tag.setTagName("@original");
                TextElement text = ast.newTextElement();
                String _string = oldBody.toString();
                String _defaultLineDelimiter = document.getDefaultLineDelimiter();
                String _replace = _string.replace("\n", _defaultLineDelimiter);
                text.setText(_replace);
                List _fragments = tag.fragments();
                _fragments.add(text);
                tagsRewrite.insertLast((ASTNode)tag, null);
            }
        } else {
            boolean _not;
            boolean bl3 = _not = !keepOld;
            if (_not) {
                tagsRewrite.remove((ASTNode)originalTag, null);
            }
        }
        if (_equals_1 = Objects.equal((Object)newTag, null)) {
            TagElement newTagToInsert = ast.newTagElement();
            newTagToInsert.setTagName(newTagName);
            TextElement tagText = ast.newTextElement();
            tagText.setText(newTagText);
            List _fragments_1 = newTagToInsert.fragments();
            _fragments_1.add(tagText);
            tagsRewrite.insertLast((ASTNode)newTagToInsert, null);
        }
        rewrite.replace((ASTNode)oldBody, (ASTNode)newBody, null);
    }

    public Iterable<IPluginExtension> extensionContribution(Pattern pattern, final ExtensionGenerator exGen) {
        boolean _hasAnnotationLiteral = this.hasAnnotationLiteral(pattern, annotationLiteral);
        if (_hasAnnotationLiteral) {
            try {
                final HashMap<String, Object> parameters = this.processDerivedFeatureAnnotation(pattern, false);
                String _derivedContributionId = this.derivedContributionId(pattern);
                Procedures.Procedure1<IPluginExtension> _function = new Procedures.Procedure1<IPluginExtension>(){

                    public void apply(IPluginExtension it) {
                        Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                            public void apply(IPluginElement it) {
                                Object _get = parameters.get("package");
                                String _nSURI = ((GenPackage)_get).getNSURI();
                                exGen.contribAttribute(it, "package-nsUri", _nSURI);
                                Object _get_1 = parameters.get("source");
                                String _name = ((EClass)_get_1).getName();
                                exGen.contribAttribute(it, "classifier-name", _name);
                                Object _get_2 = parameters.get("feature");
                                String _name_1 = ((EStructuralFeature)_get_2).getName();
                                exGen.contribAttribute(it, "feature-name", _name_1);
                            }
                        };
                        exGen.contribElement((IPluginObject)it, "wellbehaving-derived-feature", (Procedures.Procedure1)_function);
                    }
                };
                IPluginExtension _contribExtension = exGen.contribExtension(_derivedContributionId, DERIVED_EXTENSION_POINT, (Procedures.Procedure1)_function);
                ArrayList wellbehaving = CollectionLiterals.newArrayList((Object[])new IPluginExtension[]{_contribExtension});
                return wellbehaving;
            }
            catch (Throwable _t) {
                if (_t instanceof IllegalArgumentException) {
                    IllegalArgumentException e = (IllegalArgumentException)_t;
                    String _message = e.getMessage();
                    this.logger.error((Object)_message);
                    return CollectionLiterals.newArrayList((Object[])new IPluginExtension[0]);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return CollectionLiterals.newArrayList((Object[])new IPluginExtension[0]);
    }

    public Iterable<Pair<String, String>> removeExtension(Pattern pattern) {
        String _derivedContributionId = this.derivedContributionId(pattern);
        Pair _of = Pair.of((Object)_derivedContributionId, (Object)DERIVED_EXTENSION_POINT);
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new Pair[]{_of});
        return _newArrayList;
    }

    public Collection<Pair<String, String>> getRemovableExtensions() {
        Pair _of = Pair.of((Object)DERIVED_EXTENSION_PREFIX, (Object)DERIVED_EXTENSION_POINT);
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new Pair[]{_of});
        return _newArrayList;
    }

    private boolean hasAnnotationLiteral(Pattern pattern, String literal) {
        EList _annotations = pattern.getAnnotations();
        for (Annotation a : _annotations) {
            String _name = a.getName();
            boolean _matches = _name.matches(literal);
            if (!_matches) continue;
            return true;
        }
        return false;
    }

    private String derivedContributionId(Pattern pattern) {
        String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
        String _plus = String.valueOf(DERIVED_EXTENSION_PREFIX) + _fullyQualifiedName;
        return _plus;
    }

    private HashMap<String, Object> processDerivedFeatureAnnotation(Pattern pattern, boolean feedback) {
        Set<String> _keySet_1;
        boolean _contains_1;
        boolean _not_4;
        boolean _isEmpty;
        boolean _not_3;
        boolean _notEquals;
        boolean _not_1;
        Map _parameterPositionsByName;
        Set _keySet;
        boolean _contains;
        boolean _not;
        boolean _equals_1;
        EList _parameters_1;
        boolean _lessThan;
        HashMap<String, Object> _hashMap;
        HashMap<String, Object> parameters = _hashMap = new HashMap<String, Object>();
        String sourceTmp = "";
        String targetTmp = "";
        String featureTmp = "";
        String kindTmp = "";
        boolean keepCacheTmp = true;
        EList _parameters = pattern.getParameters();
        int _size = _parameters.size();
        boolean bl = _lessThan = _size < 2;
        if (_lessThan) {
            if (feedback) {
                this.errorFeedback.reportError((EObject)pattern, "Pattern has less than 2 parameters!", DERIVED_ERROR_CODE, Severity.ERROR, "org.eclipse.incquery.tooling.core.generator.marker.fragment");
            }
            String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
            String _plus = "Query-based feature pattern " + _fullyQualifiedName;
            String _plus_1 = String.valueOf(_plus) + " has less than 2 parameters!";
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus_1);
            throw _illegalArgumentException;
        }
        Annotation annotation = null;
        EList _annotations = pattern.getAnnotations();
        Functions.Function1<Annotation, Boolean> _function = new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation it) {
                String _name = it.getName();
                boolean _equalsIgnoreCase = _name.equalsIgnoreCase(annotationLiteral);
                return _equalsIgnoreCase;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_annotations, (Functions.Function1)_function);
        Iterator iterator = _filter.iterator();
        while (iterator.hasNext()) {
            Annotation a;
            annotation = a = (Annotation)iterator.next();
            _parameters_1 = a.getParameters();
            for (AnnotationParameter ap : _parameters_1) {
                boolean _isValue;
                String _name = ap.getName();
                boolean _matches = _name.matches("source");
                if (_matches) {
                    String _var;
                    ValueReference _value = ap.getValue();
                    VariableReference _value_1 = ((VariableValue)_value).getValue();
                    sourceTmp = _var = _value_1.getVar();
                    continue;
                }
                String _name_1 = ap.getName();
                boolean _matches_1 = _name_1.matches("target");
                if (_matches_1) {
                    String _var_1;
                    ValueReference _value_2 = ap.getValue();
                    VariableReference _value_3 = ((VariableValue)_value_2).getValue();
                    targetTmp = _var_1 = _value_3.getVar();
                    continue;
                }
                String _name_2 = ap.getName();
                boolean _matches_2 = _name_2.matches("feature");
                if (_matches_2) {
                    String _value_5;
                    ValueReference _value_4 = ap.getValue();
                    featureTmp = _value_5 = ((StringValue)_value_4).getValue();
                    continue;
                }
                String _name_3 = ap.getName();
                boolean _matches_3 = _name_3.matches("kind");
                if (_matches_3) {
                    String _value_7;
                    ValueReference _value_6 = ap.getValue();
                    kindTmp = _value_7 = ((StringValue)_value_6).getValue();
                    continue;
                }
                String _name_4 = ap.getName();
                boolean _matches_4 = _name_4.matches("keepCache");
                if (!_matches_4) continue;
                ValueReference _value_8 = ap.getValue();
                keepCacheTmp = _isValue = ((BoolValue)_value_8).isValue();
            }
        }
        boolean _equals = Objects.equal((Object)featureTmp, (Object)"");
        if (_equals) {
            String _name;
            featureTmp = _name = pattern.getName();
        }
        if (_equals_1 = Objects.equal((Object)sourceTmp, (Object)"")) {
            String _name_1;
            _parameters_1 = pattern.getParameters();
            Variable _get = (Variable)_parameters_1.get(0);
            sourceTmp = _name_1 = _get.getName();
        }
        boolean bl2 = _not = !(_contains = (_keySet = (_parameterPositionsByName = CorePatternLanguageHelper.getParameterPositionsByName((Pattern)pattern)).keySet()).contains(sourceTmp));
        if (_not) {
            if (feedback) {
                String _plus_2 = "No parameter for source " + sourceTmp;
                String _plus_3 = String.valueOf(_plus_2) + " !";
                this.errorFeedback.reportError((EObject)annotation, _plus_3, DERIVED_ERROR_CODE, Severity.ERROR, "org.eclipse.incquery.tooling.core.generator.marker.fragment");
            }
            String _fullyQualifiedName_1 = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
            String _plus_4 = "Query-based feature pattern " + _fullyQualifiedName_1;
            String _plus_5 = String.valueOf(_plus_4) + ": No parameter for source ";
            String _plus_6 = String.valueOf(_plus_5) + sourceTmp;
            String _plus_7 = String.valueOf(_plus_6) + " !";
            IllegalArgumentException _illegalArgumentException_1 = new IllegalArgumentException(_plus_7);
            throw _illegalArgumentException_1;
        }
        EList _parameters_2 = pattern.getParameters();
        Map _parameterPositionsByName_1 = CorePatternLanguageHelper.getParameterPositionsByName((Pattern)pattern);
        Integer _get_1 = (Integer)_parameterPositionsByName_1.get(sourceTmp);
        Variable sourcevar = (Variable)_parameters_2.get(_get_1.intValue());
        Type sourceType = sourcevar.getType();
        boolean _or = false;
        boolean bl3 = _not_1 = !(sourceType instanceof ClassType);
        if (_not_1) {
            _or = true;
        } else {
            EClassifier _classname = ((ClassType)sourceType).getClassname();
            boolean _not_2 = !(_classname instanceof EClass);
            boolean bl4 = _or = _not_1 || _not_2;
        }
        if (_or) {
            if (feedback) {
                String _plus_8 = "Source " + sourceTmp;
                String _plus_9 = String.valueOf(_plus_8) + " is not EClass!";
                this.errorFeedback.reportError((EObject)sourcevar, _plus_9, DERIVED_ERROR_CODE, Severity.ERROR, "org.eclipse.incquery.tooling.core.generator.marker.fragment");
            }
            String _fullyQualifiedName_2 = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
            String _plus_10 = "Query-based feature pattern " + _fullyQualifiedName_2;
            String _plus_11 = String.valueOf(_plus_10) + ": Source ";
            String _plus_12 = String.valueOf(_plus_11) + sourceTmp;
            String _plus_13 = String.valueOf(_plus_12) + " is not EClass!";
            IllegalArgumentException _illegalArgumentException_2 = new IllegalArgumentException(_plus_13);
            throw _illegalArgumentException_2;
        }
        EClassifier _classname_1 = ((ClassType)sourceType).getClassname();
        EClass source = (EClass)_classname_1;
        parameters.put("sourceVar", sourceTmp);
        parameters.put("source", source);
        boolean _or_1 = false;
        boolean _equals_2 = Objects.equal((Object)source, null);
        if (_equals_2) {
            _or_1 = true;
        } else {
            EPackage _ePackage = source.getEPackage();
            boolean _equals_3 = Objects.equal((Object)_ePackage, null);
            boolean bl5 = _or_1 = _equals_2 || _equals_3;
        }
        if (_or_1) {
            if (feedback) {
                this.errorFeedback.reportError((EObject)sourcevar, "Source EClass or EPackage not found!", DERIVED_ERROR_CODE, Severity.ERROR, "org.eclipse.incquery.tooling.core.generator.marker.fragment");
            }
            String _fullyQualifiedName_3 = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
            String _plus_14 = "Query-based feature pattern " + _fullyQualifiedName_3;
            String _plus_15 = String.valueOf(_plus_14) + ": Source EClass or EPackage not found!";
            IllegalArgumentException _illegalArgumentException_3 = new IllegalArgumentException(_plus_15);
            throw _illegalArgumentException_3;
        }
        EPackage _ePackage_1 = source.getEPackage();
        GenPackage pckg = this.provider.findGenPackage((EObject)pattern, _ePackage_1);
        boolean _equals_4 = Objects.equal((Object)pckg, null);
        if (_equals_4) {
            if (feedback) {
                this.errorFeedback.reportError((EObject)sourcevar, "GenPackage not found!", DERIVED_ERROR_CODE, Severity.ERROR, "org.eclipse.incquery.tooling.core.generator.marker.fragment");
            }
            String _fullyQualifiedName_4 = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
            String _plus_16 = "Query-based feature pattern " + _fullyQualifiedName_4;
            String _plus_17 = String.valueOf(_plus_16) + ": GenPackage not found!";
            IllegalArgumentException _illegalArgumentException_4 = new IllegalArgumentException(_plus_17);
            throw _illegalArgumentException_4;
        }
        parameters.put("package", pckg);
        final String featureString = featureTmp;
        EList _eAllStructuralFeatures = source.getEAllStructuralFeatures();
        Functions.Function1<EStructuralFeature, Boolean> _function_1 = new Functions.Function1<EStructuralFeature, Boolean>(){

            public Boolean apply(EStructuralFeature it) {
                String _name = it.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)featureString);
                return _equals;
            }
        };
        Iterable features = IterableExtensions.filter((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function_1);
        int _size_1 = IterableExtensions.size((Iterable)features);
        boolean bl6 = _notEquals = _size_1 != 1;
        if (_notEquals) {
            if (feedback) {
                String _plus_18 = "Feature " + featureTmp;
                String _plus_19 = String.valueOf(_plus_18) + " not found in class ";
                String _name_2 = source.getName();
                String _plus_20 = String.valueOf(_plus_19) + _name_2;
                String _plus_21 = String.valueOf(_plus_20) + "!";
                this.errorFeedback.reportError((EObject)annotation, _plus_21, DERIVED_ERROR_CODE, Severity.ERROR, "org.eclipse.incquery.tooling.core.generator.marker.fragment");
            }
            String _fullyQualifiedName_5 = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
            String _plus_22 = "Query-based feature pattern " + _fullyQualifiedName_5;
            String _plus_23 = String.valueOf(_plus_22) + ": Feature ";
            String _plus_24 = String.valueOf(_plus_23) + featureTmp;
            String _plus_25 = String.valueOf(_plus_24) + " not found in class ";
            String _name_3 = source.getName();
            String _plus_26 = String.valueOf(_plus_25) + _name_3;
            String _plus_27 = String.valueOf(_plus_26) + "!";
            IllegalArgumentException _illegalArgumentException_5 = new IllegalArgumentException(_plus_27);
            throw _illegalArgumentException_5;
        }
        Iterator _iterator = features.iterator();
        EStructuralFeature feature = (EStructuralFeature)_iterator.next();
        boolean _and = false;
        boolean _and_1 = false;
        boolean _isDerived = feature.isDerived();
        if (!_isDerived) {
            _and_1 = false;
        } else {
            boolean _isTransient = feature.isTransient();
            boolean bl7 = _and_1 = _isDerived && _isTransient;
        }
        if (!_and_1) {
            _and = false;
        } else {
            boolean _isVolatile = feature.isVolatile();
            _and = _and_1 && _isVolatile;
        }
        boolean bl8 = _not_3 = !_and;
        if (_not_3) {
            if (feedback) {
                String _plus_28 = "Feature " + featureTmp;
                String _plus_29 = String.valueOf(_plus_28) + " must be set derived, transient, volatile, non-changeable!";
                this.errorFeedback.reportError((EObject)annotation, _plus_29, DERIVED_ERROR_CODE, Severity.ERROR, "org.eclipse.incquery.tooling.core.generator.marker.fragment");
            }
            String _fullyQualifiedName_6 = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
            String _plus_30 = "Query-based feature pattern " + _fullyQualifiedName_6;
            String _plus_31 = String.valueOf(_plus_30) + ": Feature ";
            String _plus_32 = String.valueOf(_plus_31) + featureTmp;
            String _plus_33 = String.valueOf(_plus_32) + " must be set derived, transient, volatile!";
            IllegalArgumentException _illegalArgumentException_6 = new IllegalArgumentException(_plus_33);
            throw _illegalArgumentException_6;
        }
        parameters.put("feature", feature);
        boolean _equals_5 = Objects.equal((Object)kindTmp, (Object)"");
        if (_equals_5) {
            boolean _isMany = feature.isMany();
            kindTmp = _isMany ? "many" : "single";
        }
        if (_isEmpty = kinds.isEmpty()) {
            kinds.put("single", QueryBasedFeatureKind.SINGLE_REFERENCE);
            kinds.put("many", QueryBasedFeatureKind.MANY_REFERENCE);
            kinds.put("counter", QueryBasedFeatureKind.COUNTER);
            kinds.put("sum", QueryBasedFeatureKind.SUM);
            kinds.put("iteration", QueryBasedFeatureKind.ITERATION);
        }
        boolean bl9 = _not_4 = !(_contains_1 = (_keySet_1 = kinds.keySet()).contains(kindTmp));
        if (_not_4) {
            if (feedback) {
                Set<String> _keySet_2 = kinds.keySet();
                String _plus_34 = "Kind not set, or not in " + _keySet_2;
                String _plus_35 = String.valueOf(_plus_34) + "!";
                this.errorFeedback.reportError((EObject)annotation, _plus_35, DERIVED_ERROR_CODE, Severity.ERROR, "org.eclipse.incquery.tooling.core.generator.marker.fragment");
            }
            String _fullyQualifiedName_7 = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
            String _plus_36 = "Query-based feature pattern " + _fullyQualifiedName_7;
            String _plus_37 = String.valueOf(_plus_36) + ": Kind not set, or not in ";
            Set<String> _keySet_3 = kinds.keySet();
            String _plus_38 = String.valueOf(_plus_37) + _keySet_3;
            String _plus_39 = String.valueOf(_plus_38) + "!";
            IllegalArgumentException _illegalArgumentException_7 = new IllegalArgumentException(_plus_39);
            throw _illegalArgumentException_7;
        }
        QueryBasedFeatureKind kind = kinds.get(kindTmp);
        parameters.put("kind", kind);
        boolean _equals_6 = Objects.equal((Object)targetTmp, (Object)"");
        if (_equals_6) {
            String _name_4;
            EList _parameters_3 = pattern.getParameters();
            Variable _get_2 = (Variable)_parameters_3.get(1);
            targetTmp = _name_4 = _get_2.getName();
        } else {
            boolean _not_5;
            Map _parameterPositionsByName_2 = CorePatternLanguageHelper.getParameterPositionsByName((Pattern)pattern);
            Set _keySet_4 = _parameterPositionsByName_2.keySet();
            boolean _contains_2 = _keySet_4.contains(targetTmp);
            boolean bl10 = _not_5 = !_contains_2;
            if (_not_5) {
                if (feedback) {
                    String _plus_40 = "Target " + targetTmp;
                    String _plus_41 = String.valueOf(_plus_40) + " not set or no such parameter!";
                    this.errorFeedback.reportError((EObject)annotation, _plus_41, DERIVED_ERROR_CODE, Severity.ERROR, "org.eclipse.incquery.tooling.core.generator.marker.fragment");
                }
                String _fullyQualifiedName_8 = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
                String _plus_42 = "Derived feature pattern " + _fullyQualifiedName_8;
                String _plus_43 = String.valueOf(_plus_42) + ": Target ";
                String _plus_44 = String.valueOf(_plus_43) + targetTmp;
                String _plus_45 = String.valueOf(_plus_44) + " not set or no such parameter!";
                IllegalArgumentException _illegalArgumentException_8 = new IllegalArgumentException(_plus_45);
                throw _illegalArgumentException_8;
            }
        }
        parameters.put("targetVar", targetTmp);
        parameters.put("keepCache", keepCacheTmp);
        return parameters;
    }

    public IPath[] getAdditionalBinIncludes() {
        return (IPath[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new IPath[0]), IPath.class);
    }

    public String[] getProjectDependencies() {
        return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[0]), String.class);
    }

    public String getProjectPostfix() {
        return null;
    }
}

