/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.querybasedfeatures.runtime;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicSettingDelegate;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureSettingDelegate;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;

public class QueryBasedFeatureSettingDelegateFactory
implements EStructuralFeature.Internal.SettingDelegate.Factory {
    private final boolean useManagedEngines;
    private final Map<Notifier, WeakReference<AdvancedIncQueryEngine>> engineMap;

    public QueryBasedFeatureSettingDelegateFactory() {
        this.useManagedEngines = true;
        this.engineMap = null;
    }

    public QueryBasedFeatureSettingDelegateFactory(boolean useManagedEngines) {
        this.useManagedEngines = useManagedEngines;
        this.engineMap = new WeakHashMap<Notifier, WeakReference<AdvancedIncQueryEngine>>();
    }

    protected AdvancedIncQueryEngine getEngineForNotifier(Notifier notifier) throws IncQueryException {
        if (this.useManagedEngines) {
            return AdvancedIncQueryEngine.from((IncQueryEngine)IncQueryEngine.on((Notifier)notifier));
        }
        WeakReference<AdvancedIncQueryEngine> reference = this.engineMap.get(notifier);
        if (reference != null && reference.get() != null) {
            return (AdvancedIncQueryEngine)reference.get();
        }
        AdvancedIncQueryEngine unmanagedEngine = AdvancedIncQueryEngine.createUnmanagedEngine((Notifier)notifier);
        this.engineMap.put(notifier, new WeakReference<AdvancedIncQueryEngine>(unmanagedEngine));
        return unmanagedEngine;
    }

    public EStructuralFeature.Internal.SettingDelegate createSettingDelegate(EStructuralFeature eStructuralFeature) {
        QueryBasedFeatureSettingDelegate result = null;
        try {
            result = new QueryBasedFeatureSettingDelegate(eStructuralFeature, this);
        }
        catch (IncQueryException incQueryException) {
            return new BasicSettingDelegate.Stateless(eStructuralFeature){

                protected boolean isSet(InternalEObject owner) {
                    return false;
                }

                protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
                    if (this.eStructuralFeature.isMany()) {
                        return ECollections.EMPTY_ELIST;
                    }
                    return null;
                }
            };
        }
        return result;
    }
}

