/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;

public abstract class BaseNode
implements Node {
    protected ReteContainer reteContainer;
    protected long nodeId;
    protected Object tag;
    protected List<Node.TraceInfo> traceInfos;

    public BaseNode(ReteContainer reteContainer) {
        this.reteContainer = reteContainer;
        this.nodeId = reteContainer.registerNode(this);
        this.traceInfos = new ArrayList<Node.TraceInfo>();
    }

    public String toString() {
        if (this.tag != null) {
            return String.valueOf(this.toStringCore()) + "->" + this.getTraceInfoPatternsEnumerated() + "{" + this.tag.toString() + "}";
        }
        return String.valueOf(this.toStringCore()) + "->" + this.getTraceInfoPatternsEnumerated();
    }

    protected String toStringCore() {
        return "[" + this.nodeId + "]" + this.getClass().getSimpleName();
    }

    @Override
    public ReteContainer getContainer() {
        return this.reteContainer;
    }

    @Override
    public long getNodeId() {
        return this.nodeId;
    }

    @Override
    public Object getTag() {
        return this.tag;
    }

    @Override
    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Override
    public List<Node.TraceInfo> getTraceInfos() {
        return Collections.unmodifiableList(this.traceInfos);
    }

    @Override
    public void assignTraceInfo(Node.TraceInfo traceInfo) {
        this.traceInfos.add(traceInfo);
    }

    @Override
    public void acceptPropagatedTraceInfo(Node.TraceInfo traceInfo) {
        this.assignTraceInfo(traceInfo);
    }

    protected String getTraceInfoPatternsEnumerated() {
        TreeSet<String> patternNames = new TreeSet<String>();
        for (Node.TraceInfo trInfo : this.traceInfos) {
            if (!(trInfo instanceof Node.TraceInfo.PatternTraceInfo)) continue;
            String pName = ((Node.TraceInfo.PatternTraceInfo)trInfo).getPatternName();
            patternNames.add(pName);
        }
        return patternNames.toString();
    }
}

