/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IRunOnceQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.IncQueryModelUpdateListener;
import org.eclipse.incquery.runtime.base.api.BaseIndexOptions;
import org.eclipse.incquery.runtime.exception.IncQueryException;

public class RunOnceQueryEngine
implements IRunOnceQueryEngine {
    private Notifier notifier;
    private RunOnceBaseIndexOptions baseIndexOptions;
    private AdvancedIncQueryEngine engine;
    private boolean reSamplingNeeded = false;
    protected boolean samplingMode = false;
    private RunOnceSamplingModelUpdateListener modelUpdateListener;

    public RunOnceQueryEngine(Notifier notifier) {
        this.notifier = notifier;
        this.baseIndexOptions = new RunOnceBaseIndexOptions();
    }

    @Override
    public <Match extends IPatternMatch> Collection<Match> getAllMatches(IQuerySpecification<? extends IncQueryMatcher<Match>> querySpecification) throws IncQueryException {
        if (this.samplingMode && this.reSamplingNeeded && this.engine != null) {
            this.engine.getBaseIndex().resampleDerivedFeatures();
        } else {
            this.engine = AdvancedIncQueryEngine.createUnmanagedEngine(this.notifier, this.baseIndexOptions);
        }
        IncQueryMatcher<Match> matcher = this.engine.getMatcher(querySpecification);
        Collection<Match> allMatches = matcher.getAllMatches();
        if (this.samplingMode) {
            this.engine.addModelUpdateListener(this.modelUpdateListener);
        } else {
            this.engine.dispose();
            this.engine = null;
        }
        return allMatches;
    }

    @Override
    public BaseIndexOptions getBaseIndexOptions() {
        return this.baseIndexOptions;
    }

    @Override
    public Notifier getScope() {
        return this.notifier;
    }

    @Override
    public void setAutomaticResampling(boolean automaticResampling) {
        this.samplingMode = automaticResampling;
        if (automaticResampling) {
            if (this.modelUpdateListener == null) {
                this.modelUpdateListener = new RunOnceSamplingModelUpdateListener();
            }
        } else if (this.engine != null) {
            this.engine.dispose();
            this.engine = null;
        }
    }

    @Override
    public void resampleOnNextCall() {
        this.reSamplingNeeded = true;
    }

    private static final class RunOnceBaseIndexOptions
    extends BaseIndexOptions {
        public RunOnceBaseIndexOptions() {
            this.traverseOnlyWellBehavingDerivedFeatures = false;
        }
    }

    private final class RunOnceSamplingModelUpdateListener
    implements IncQueryModelUpdateListener {
        private RunOnceSamplingModelUpdateListener() {
        }

        @Override
        public void notifyChanged(IncQueryModelUpdateListener.ChangeLevel changeLevel) {
            RunOnceQueryEngine.this.reSamplingNeeded = true;
        }

        @Override
        public IncQueryModelUpdateListener.ChangeLevel getLevel() {
            return IncQueryModelUpdateListener.ChangeLevel.MODEL;
        }
    }
}

