/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HierarchyPolicy implements Enumerator
{
    PORT(0, "Port", "Port"),
    ALWAYS(1, "Always", "Always"),
    CHILD(2, "Child", "Child"),
    ROOT(3, "Root", "Root");

    public static final int PORT_VALUE = 0;
    public static final int ALWAYS_VALUE = 1;
    public static final int CHILD_VALUE = 2;
    public static final int ROOT_VALUE = 3;
    private static final HierarchyPolicy[] VALUES_ARRAY;
    public static final List<HierarchyPolicy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HierarchyPolicy[]{PORT, ALWAYS, CHILD, ROOT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HierarchyPolicy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HierarchyPolicy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HierarchyPolicy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HierarchyPolicy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HierarchyPolicy get(int value) {
        switch (value) {
            case 0: {
                return PORT;
            }
            case 1: {
                return ALWAYS;
            }
            case 2: {
                return CHILD;
            }
            case 3: {
                return ROOT;
            }
        }
        return null;
    }

    private HierarchyPolicy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

