package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.ClassifierAttributeMatch;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.classifierAttribute pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ClassifierAttributeProcessor implements IMatchProcessor<ClassifierAttributeMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final Classifier pSource, final Property pTarget);
  
  @Override
  public void process(final ClassifierAttributeMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
