package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.ConnectableElementEndMatch;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.connectableElementEnd pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ConnectableElementEndProcessor implements IMatchProcessor<ConnectableElementEndMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pTemp1 the value of pattern parameter temp1 in the currently processed match
   * 
   */
  public abstract void process(final ConnectableElement pSelf, final ConnectorEnd pTemp1);
  
  @Override
  public void process(final ConnectableElementEndMatch match) {
    process(match.getSelf(), match.getTemp1());
  }
}
