/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.command;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.seproxy.message.ApduResponse;

public abstract class AbstractApduResponseParser {
    protected ApduResponse response;
    protected static final Map<Integer, StatusProperties> STATUS_TABLE;
    private boolean initialized;

    protected Map<Integer, StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    @Deprecated
    public AbstractApduResponseParser(ApduResponse response) {
        this.response = response;
        this.initialized = true;
    }

    public AbstractApduResponseParser() {
        this.initialized = false;
    }

    public final void setApduResponse(ApduResponse response) {
        this.response = response;
        this.initialized = true;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final ApduResponse getApduResponse() {
        if (!this.initialized) {
            throw new IllegalStateException("The parser has not been initialized.");
        }
        return this.response;
    }

    private int getStatusCode() {
        return this.response.getStatusCode();
    }

    private StatusProperties getPropertiesForStatusCode() {
        return this.getStatusTable().get(this.getStatusCode());
    }

    public boolean isSuccessful() {
        if (!this.initialized) {
            throw new IllegalStateException("The parser has not been initialized.");
        }
        StatusProperties props = this.getPropertiesForStatusCode();
        return props != null && props.isSuccessful();
    }

    public final String getStatusInformation() {
        StatusProperties props = this.getPropertiesForStatusCode();
        return props != null ? props.getInformation() : null;
    }

    static {
        HashMap<Integer, StatusProperties> m = new HashMap<Integer, StatusProperties>();
        m.put(36864, new StatusProperties(true, "Success"));
        STATUS_TABLE = m;
    }

    protected static class StatusProperties {
        private final boolean successful;
        private final String information;

        public StatusProperties(boolean successful, String information) {
            this.successful = successful;
            this.information = information;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        String getInformation() {
            return this.information;
        }
    }
}

