/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.keyple.seproxy.ReaderPlugin;
import org.eclipse.keyple.seproxy.exception.KeyplePluginNotFoundException;

public final class SeProxyService {
    private static SeProxyService uniqueInstance = new SeProxyService();
    private SortedSet<ReaderPlugin> plugins = new ConcurrentSkipListSet<ReaderPlugin>();

    private SeProxyService() {
    }

    public static SeProxyService getInstance() {
        return uniqueInstance;
    }

    public void setPlugins(SortedSet<ReaderPlugin> plugins) {
        this.plugins = plugins;
    }

    public void addPlugin(ReaderPlugin plugin) {
        this.plugins.add(plugin);
    }

    public SortedSet<ReaderPlugin> getPlugins() {
        return this.plugins;
    }

    public ReaderPlugin getPlugin(String name) throws KeyplePluginNotFoundException {
        for (ReaderPlugin plugin : this.plugins) {
            if (!plugin.getName().equals(name)) continue;
            return plugin;
        }
        throw new KeyplePluginNotFoundException(name);
    }

    public String getVersion() {
        try {
            InputStream propertiesIs = this.getClass().getClassLoader().getResourceAsStream("META-INF/keyple-core.properties");
            Properties prop = new Properties();
            prop.load(propertiesIs);
            String version = prop.getProperty("version");
            if (version != null) {
                return version;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "no-version-found";
    }
}

