/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.seproxy.SeSelector;
import org.eclipse.keyple.seproxy.event.DefaultSelectionRequest;
import org.eclipse.keyple.seproxy.event.ObservableReader;
import org.eclipse.keyple.seproxy.event.ReaderEvent;
import org.eclipse.keyple.seproxy.event.SelectionResponse;
import org.eclipse.keyple.seproxy.exception.KeypleApplicationSelectionException;
import org.eclipse.keyple.seproxy.exception.KeypleChannelStateException;
import org.eclipse.keyple.seproxy.exception.KeypleIOReaderException;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.exception.NoStackTraceThrowable;
import org.eclipse.keyple.seproxy.message.ApduRequest;
import org.eclipse.keyple.seproxy.message.ApduResponse;
import org.eclipse.keyple.seproxy.message.SeRequest;
import org.eclipse.keyple.seproxy.message.SeRequestSet;
import org.eclipse.keyple.seproxy.message.SeResponse;
import org.eclipse.keyple.seproxy.message.SeResponseSet;
import org.eclipse.keyple.seproxy.message.SelectionStatus;
import org.eclipse.keyple.seproxy.plugin.AbstractObservableReader;
import org.eclipse.keyple.seproxy.protocol.SeProtocol;
import org.eclipse.keyple.seproxy.protocol.SeProtocolSetting;
import org.eclipse.keyple.util.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocalReader
extends AbstractObservableReader {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLocalReader.class);
    private static final byte[] getResponseHackRequestBytes = ByteArrayUtils.fromHex("00C0000000");
    private boolean logicalChannelIsOpen = false;
    private byte[] aidCurrentlySelected;
    private SelectionStatus currentSelectionStatus;
    private boolean presenceNotified = false;
    private long before;
    protected Map<SeProtocol, String> protocolsMap = new HashMap<SeProtocol, String>();

    public AbstractLocalReader(String pluginName, String readerName) {
        super(pluginName, readerName);
        this.before = System.nanoTime();
    }

    @Override
    public final boolean isSePresent() throws NoStackTraceThrowable {
        if (this.checkSePresence()) {
            return true;
        }
        if (this.isLogicalChannelOpen() || this.isPhysicalChannelOpen()) {
            this.cardRemoved();
        }
        return false;
    }

    protected abstract boolean checkSePresence() throws NoStackTraceThrowable;

    protected final void cardInserted() {
        if (this.defaultSelectionRequest == null) {
            this.notifyObservers(new ReaderEvent(this.pluginName, this.name, ReaderEvent.EventType.SE_INSERTED, null));
            this.presenceNotified = true;
        } else {
            boolean aSeMatched = false;
            try {
                SeResponseSet seResponseSet = this.processSeRequestSet(this.defaultSelectionRequest.getSelectionSeRequestSet());
                for (SeResponse seResponse : seResponseSet.getResponses()) {
                    if (seResponse == null || !seResponse.getSelectionStatus().hasMatched()) continue;
                    aSeMatched = true;
                    break;
                }
                if (this.notificationMode == ObservableReader.NotificationMode.MATCHED_ONLY) {
                    if (aSeMatched) {
                        this.notifyObservers(new ReaderEvent(this.pluginName, this.name, ReaderEvent.EventType.SE_MATCHED, new SelectionResponse(seResponseSet)));
                        this.presenceNotified = true;
                    } else {
                        this.closeLogicalChannel();
                    }
                } else {
                    if (aSeMatched) {
                        this.notifyObservers(new ReaderEvent(this.pluginName, this.name, ReaderEvent.EventType.SE_MATCHED, new SelectionResponse(seResponseSet)));
                    } else {
                        this.notifyObservers(new ReaderEvent(this.pluginName, this.name, ReaderEvent.EventType.SE_INSERTED, new SelectionResponse(seResponseSet)));
                    }
                    this.presenceNotified = true;
                }
            }
            catch (KeypleReaderException e) {
                this.closeLogicalChannel();
                e.printStackTrace();
            }
        }
    }

    protected final void cardRemoved() throws NoStackTraceThrowable {
        if (this.presenceNotified) {
            this.notifyObservers(new ReaderEvent(this.pluginName, this.name, ReaderEvent.EventType.SE_REMOVAL, null));
            this.presenceNotified = false;
        }
        this.closeLogicalChannel();
        try {
            this.closePhysicalChannel();
        }
        catch (KeypleChannelStateException e) {
            logger.trace("[{}] Exception occured in waitForCardAbsent. Message: {}", (Object)this.getName(), (Object)e.getMessage());
            throw new NoStackTraceThrowable();
        }
    }

    protected abstract byte[] getATR();

    protected abstract SelectionStatus openLogicalChannel(SeSelector var1) throws KeypleIOReaderException, KeypleChannelStateException, KeypleApplicationSelectionException;

    protected final SelectionStatus openLogicalChannelAndSelect(SeSelector seSelector) throws KeypleChannelStateException, KeypleIOReaderException, KeypleApplicationSelectionException {
        if (seSelector == null) {
            throw new KeypleChannelStateException("Try to open logical channel without selector.");
        }
        if (!this.isLogicalChannelOpen()) {
            if (!this.isPhysicalChannelOpen()) {
                this.openPhysicalChannel();
            }
            if (!this.isPhysicalChannelOpen()) {
                throw new KeypleChannelStateException("Fail to open physical channel.");
            }
        }
        SelectionStatus selectionStatus = this.openLogicalChannel(seSelector);
        return selectionStatus;
    }

    protected abstract void openPhysicalChannel() throws KeypleChannelStateException;

    protected abstract void closePhysicalChannel() throws KeypleChannelStateException;

    protected abstract boolean isPhysicalChannelOpen();

    final boolean isLogicalChannelOpen() {
        return this.logicalChannelIsOpen;
    }

    private void closeLogicalChannel() {
        logger.trace("[{}] closeLogicalChannel => Closing of the logical channel.", (Object)this.getName());
        this.logicalChannelIsOpen = false;
        this.aidCurrentlySelected = null;
        this.currentSelectionStatus = null;
    }

    @Override
    public void addSeProtocolSetting(SeProtocolSetting seProtocolSetting) {
        this.protocolsMap.putAll(seProtocolSetting.getProtocolsMap());
    }

    protected abstract boolean protocolFlagMatches(SeProtocol var1) throws KeypleReaderException;

    @Override
    protected final SeResponseSet processSeRequestSet(SeRequestSet requestSet) throws KeypleReaderException {
        boolean[] requestMatchesProtocol = new boolean[requestSet.getRequests().size()];
        int requestIndex = 0;
        for (SeRequest request : requestSet.getRequests()) {
            requestMatchesProtocol[requestIndex] = this.protocolFlagMatches(request.getProtocolFlag());
            ++requestIndex;
        }
        int lastRequestIndex = requestIndex;
        requestIndex = 0;
        ArrayList<SeResponse> responses = new ArrayList<SeResponse>();
        boolean stopProcess = false;
        for (SeRequest request : requestSet.getRequests()) {
            if (stopProcess) continue;
            if (requestMatchesProtocol[requestIndex]) {
                logger.debug("[{}] processSeRequestSet => transmit {}", (Object)this.getName(), (Object)request);
                SeResponse response = null;
                try {
                    response = this.processSeRequestLogical(request);
                }
                catch (KeypleReaderException ex) {
                    responses.add(ex.getSeResponse());
                    ex.setSeResponseSet(new SeResponseSet(responses));
                    logger.debug("[{}] processSeRequestSet => transmit : process interrupted, collect previous responses {}", (Object)this.getName(), responses);
                    throw ex;
                }
                responses.add(response);
                logger.debug("[{}] processSeRequestSet => receive {}", (Object)this.getName(), (Object)response);
            } else {
                responses.add(null);
            }
            ++requestIndex;
            if (!request.isKeepChannelOpen()) {
                if (lastRequestIndex != requestIndex) continue;
                this.closePhysicalChannel();
                logger.debug("[{}] processSeRequestSet => Closing of the physical channel.", (Object)this.getName());
                continue;
            }
            if (!this.isLogicalChannelOpen()) continue;
            stopProcess = true;
        }
        return new SeResponseSet(responses);
    }

    @Override
    protected final SeResponse processSeRequest(SeRequest seRequest) throws IllegalStateException, KeypleReaderException {
        SeResponse seResponse = this.processSeRequestLogical(seRequest);
        if (!seRequest.isKeepChannelOpen()) {
            this.closePhysicalChannel();
        }
        return seResponse;
    }

    private SeResponse processSeRequestLogical(SeRequest seRequest) throws IllegalStateException, KeypleReaderException {
        boolean previouslyOpen = true;
        SelectionStatus selectionStatus = null;
        ArrayList<ApduResponse> apduResponseList = new ArrayList<ApduResponse>();
        logger.trace("[{}] processSeRequest => Logical channel open = {}", (Object)this.getName(), (Object)this.isLogicalChannelOpen());
        if (seRequest.getSeSelector() != null) {
            if (this.isLogicalChannelOpen() && seRequest.getSeSelector().getAidSelector() != null) {
                if (this.aidCurrentlySelected == null) {
                    throw new IllegalStateException("AID currently selected shouldn't be null.");
                }
                if (seRequest.getSeSelector().getAidSelector().isSelectNext()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("[{}] processSeRequest => The current selection is a next selection, close the logical channel.", (Object)this.getName());
                    }
                    this.closeLogicalChannel();
                } else if (seRequest.getSeSelector().getAidSelector().getAidToSelect().length >= this.aidCurrentlySelected.length && this.aidCurrentlySelected.equals(Arrays.copyOfRange(seRequest.getSeSelector().getAidSelector().getAidToSelect(), 0, this.aidCurrentlySelected.length))) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("[{}] processSeRequest => The AID changed, close the logical channel. AID = {}, EXPECTEDAID = {}", new Object[]{this.getName(), ByteArrayUtils.toHex(this.aidCurrentlySelected), seRequest.getSeSelector()});
                    }
                    this.closeLogicalChannel();
                }
                selectionStatus = this.currentSelectionStatus;
            }
            if (!this.isLogicalChannelOpen()) {
                previouslyOpen = false;
                try {
                    selectionStatus = this.openLogicalChannelAndSelect(seRequest.getSeSelector());
                    logger.trace("[{}] processSeRequest => Logical channel opening success.", (Object)this.getName());
                }
                catch (KeypleApplicationSelectionException e) {
                    logger.trace("[{}] processSeRequest => Logical channel opening failure", (Object)this.getName());
                    this.closeLogicalChannel();
                    return null;
                }
                if (selectionStatus.hasMatched()) {
                    this.logicalChannelIsOpen = true;
                    if (selectionStatus.getFci().isSuccessful()) {
                        this.aidCurrentlySelected = seRequest.getSeSelector().getAidSelector().getAidToSelect();
                    }
                    this.currentSelectionStatus = selectionStatus;
                } else {
                    this.closeLogicalChannel();
                }
            }
        } else {
            if (!this.isLogicalChannelOpen()) {
                throw new IllegalStateException("[" + this.getName() + "] processSeRequest => No logical channel opened!");
            }
            selectionStatus = null;
        }
        if (seRequest.getApduRequests() != null) {
            for (ApduRequest apduRequest : seRequest.getApduRequests()) {
                try {
                    apduResponseList.add(this.processApduRequest(apduRequest));
                }
                catch (KeypleIOReaderException ex) {
                    logger.debug("The process has been interrupted, collect Apdu responses collected so far");
                    this.closeLogicalChannel();
                    ex.setSeResponse(new SeResponse(previouslyOpen, selectionStatus, apduResponseList));
                    throw ex;
                }
            }
        }
        if (!seRequest.isKeepChannelOpen()) {
            this.closeLogicalChannel();
        }
        return new SeResponse(previouslyOpen, selectionStatus, apduResponseList);
    }

    protected final ApduResponse processApduRequest(ApduRequest apduRequest) throws KeypleIOReaderException {
        if (logger.isTraceEnabled()) {
            long timeStamp = System.nanoTime();
            double elapsedMs = (double)((timeStamp - this.before) / 100000L) / 10.0;
            this.before = timeStamp;
            logger.trace("[{}] processApduRequest => {}, elapsed {} ms.", new Object[]{this.getName(), apduRequest, elapsedMs});
        }
        byte[] buffer = apduRequest.getBytes();
        ApduResponse apduResponse = new ApduResponse(this.transmitApdu(buffer), apduRequest.getSuccessfulStatusCodes());
        if (apduRequest.isCase4() && apduResponse.getDataOut().length == 0 && apduResponse.isSuccessful()) {
            apduResponse = this.case4HackGetResponse(apduResponse.getStatusCode());
        }
        if (logger.isTraceEnabled()) {
            long timeStamp = System.nanoTime();
            double elapsedMs = (double)((timeStamp - this.before) / 100000L) / 10.0;
            this.before = timeStamp;
            logger.trace("[{}] processApduRequest => {}, elapsed {} ms.", new Object[]{this.getName(), apduResponse, elapsedMs});
        }
        return apduResponse;
    }

    private ApduResponse case4HackGetResponse(int originalStatusCode) throws KeypleIOReaderException {
        if (logger.isTraceEnabled()) {
            long timeStamp = System.nanoTime();
            double elapsedMs = (double)((timeStamp - this.before) / 100000L) / 10.0;
            this.before = timeStamp;
            logger.trace("[{}] case4HackGetResponse => ApduRequest: NAME = \"Internal Get Response\", RAWDATA = {}, elapsed = {}", new Object[]{this.getName(), ByteArrayUtils.toHex(getResponseHackRequestBytes), elapsedMs});
        }
        byte[] getResponseHackResponseBytes = this.transmitApdu(getResponseHackRequestBytes);
        ApduResponse getResponseHackResponse = new ApduResponse(getResponseHackResponseBytes, null);
        if (logger.isTraceEnabled()) {
            long timeStamp = System.nanoTime();
            double elapsedMs = (double)((timeStamp - this.before) / 100000L) / 10.0;
            this.before = timeStamp;
            logger.trace("[{}] case4HackGetResponse => Internal {}, elapsed {} ms.", new Object[]{this.getName(), getResponseHackResponseBytes, elapsedMs});
        }
        if (getResponseHackResponse.isSuccessful()) {
            getResponseHackResponseBytes[getResponseHackResponseBytes.length - 2] = (byte)(originalStatusCode >> 8);
            getResponseHackResponseBytes[getResponseHackResponseBytes.length - 1] = (byte)(originalStatusCode & 0xFF);
        }
        return getResponseHackResponse;
    }

    protected abstract byte[] transmitApdu(byte[] var1) throws KeypleIOReaderException;

    @Override
    public void setDefaultSelectionRequest(DefaultSelectionRequest defaultSelectionRequest, ObservableReader.NotificationMode notificationMode) {
        this.defaultSelectionRequest = defaultSelectionRequest;
        this.notificationMode = notificationMode;
    }
}

