/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.pluginse;

import com.google.gson.JsonObject;
import org.eclipse.keyple.plugin.remotese.pluginse.RemoteSePlugin;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethod;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethodExecutor;
import org.eclipse.keyple.plugin.remotese.transport.KeypleDtoHelper;
import org.eclipse.keyple.plugin.remotese.transport.json.JsonParser;
import org.eclipse.keyple.plugin.remotese.transport.model.KeypleDto;
import org.eclipse.keyple.plugin.remotese.transport.model.TransportDto;
import org.eclipse.keyple.seproxy.exception.KeypleReaderNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmDisconnectReaderExecutor
implements RemoteMethodExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RmDisconnectReaderExecutor.class);
    private final RemoteSePlugin plugin;

    public RmDisconnectReaderExecutor(RemoteSePlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public TransportDto execute(TransportDto transportDto) {
        KeypleDto keypleDto = transportDto.getKeypleDTO();
        String nativeReaderName = keypleDto.getNativeReaderName();
        String clientNodeId = keypleDto.getNodeId();
        String sessionId = keypleDto.getSessionId();
        try {
            this.plugin.disconnectRemoteReader(nativeReaderName);
            JsonObject body = new JsonObject();
            body.addProperty("status", Boolean.valueOf(true));
            return transportDto.nextTransportDTO(new KeypleDto(RemoteMethod.READER_DISCONNECT.getName(), JsonParser.getGson().toJson((Object)body, JsonObject.class), false, null, nativeReaderName, null, clientNodeId));
        }
        catch (KeypleReaderNotFoundException e) {
            logger.error("Impossible to disconnect reader " + nativeReaderName, (Throwable)e);
            return transportDto.nextTransportDTO(KeypleDtoHelper.ExceptionDTO(RemoteMethod.READER_DISCONNECT.getName(), e, keypleDto.getSessionId(), keypleDto.getNativeReaderName(), keypleDto.getVirtualReaderName(), keypleDto.getNodeId()));
        }
    }
}

