/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.pluginse;

import java.util.Map;
import org.eclipse.keyple.plugin.remotese.exception.KeypleRemoteException;
import org.eclipse.keyple.plugin.remotese.exception.KeypleRemoteReaderException;
import org.eclipse.keyple.plugin.remotese.pluginse.VirtualReaderSession;
import org.eclipse.keyple.plugin.remotese.pluginse.method.RmSetDefaultSelectionRequestTx;
import org.eclipse.keyple.plugin.remotese.pluginse.method.RmTransmitTx;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethodTxEngine;
import org.eclipse.keyple.seproxy.event.DefaultSelectionRequest;
import org.eclipse.keyple.seproxy.event.ObservableReader;
import org.eclipse.keyple.seproxy.event.ReaderEvent;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.message.SeRequest;
import org.eclipse.keyple.seproxy.message.SeRequestSet;
import org.eclipse.keyple.seproxy.message.SeResponse;
import org.eclipse.keyple.seproxy.message.SeResponseSet;
import org.eclipse.keyple.seproxy.plugin.AbstractObservableReader;
import org.eclipse.keyple.seproxy.protocol.SeProtocolSetting;
import org.eclipse.keyple.seproxy.protocol.TransmissionMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VirtualReader
extends AbstractObservableReader {
    private final VirtualReaderSession session;
    private final String nativeReaderName;
    private final RemoteMethodTxEngine rmTxEngine;
    private static final Logger logger = LoggerFactory.getLogger(VirtualReader.class);

    VirtualReader(VirtualReaderSession session, String nativeReaderName, RemoteMethodTxEngine rmTxEngine) {
        super("RemoteSePlugin", "remote-" + nativeReaderName);
        this.session = session;
        this.nativeReaderName = nativeReaderName;
        this.rmTxEngine = rmTxEngine;
        logger.info("A new virtual reader was created with session {}", (Object)session);
    }

    public TransmissionMode getTransmissionMode() {
        logger.error("getTransmissionMode is not implemented yet");
        return null;
    }

    public String getNativeReaderName() {
        return this.nativeReaderName;
    }

    public VirtualReaderSession getSession() {
        return this.session;
    }

    RemoteMethodTxEngine getRmTxEngine() {
        return this.rmTxEngine;
    }

    public boolean isSePresent() {
        logger.error("isSePresent is not implemented yet");
        return false;
    }

    protected SeResponseSet processSeRequestSet(SeRequestSet seRequestSet) throws IllegalArgumentException, KeypleReaderException {
        RmTransmitTx transmit = new RmTransmitTx(seRequestSet, this.session.getSessionId(), this.getNativeReaderName(), this.getName(), this.session.getSlaveNodeId());
        try {
            this.rmTxEngine.register(transmit);
            return (SeResponseSet)transmit.get();
        }
        catch (KeypleRemoteException e) {
            e.printStackTrace();
            throw (KeypleReaderException)e.getCause();
        }
    }

    protected SeResponse processSeRequest(SeRequest seRequest) throws IllegalArgumentException, KeypleReaderException {
        try {
            return this.processSeRequestSet(new SeRequestSet(seRequest)).getSingleResponse();
        }
        catch (KeypleRemoteReaderException e) {
            throw (KeypleReaderException)e.getCause();
        }
    }

    protected void startObservation() {
    }

    protected void stopObservation() {
    }

    public void addSeProtocolSetting(SeProtocolSetting seProtocolSetting) {
        logger.error("addSeProtocolSetting is not implemented yet");
    }

    void onRemoteReaderEvent(ReaderEvent event) {
        VirtualReader thisReader = this;
        logger.debug(" EVENT {} ", (Object)event.getEventType());
        if (thisReader.countObservers() > 0) {
            thisReader.notifyObservers(event);
        } else {
            logger.debug("An event was received but no observers are declared into VirtualReader : {} {}", (Object)thisReader.getName(), (Object)event.getEventType());
        }
    }

    public Map<String, String> getParameters() {
        logger.error("getParameters is not implemented yet");
        return null;
    }

    public void setParameter(String key, String value) throws IllegalArgumentException {
        logger.error("setParameter is not implemented yet");
    }

    public void setDefaultSelectionRequest(DefaultSelectionRequest defaultSelectionRequest, ObservableReader.NotificationMode notificationMode) {
        RmSetDefaultSelectionRequestTx setDefaultSelectionRequest = new RmSetDefaultSelectionRequestTx(defaultSelectionRequest, notificationMode, this.getNativeReaderName(), this.getName(), this.getSession().getSessionId(), this.session.getSlaveNodeId());
        try {
            this.rmTxEngine.register(setDefaultSelectionRequest);
            setDefaultSelectionRequest.get();
        }
        catch (KeypleRemoteException e) {
            logger.error("setDefaultSelectionRequest encounters an exception while communicating with slave", (Throwable)((Object)e));
        }
    }
}

