/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.transport.impl.java;

import org.eclipse.keyple.plugin.remotese.transport.DtoHandler;
import org.eclipse.keyple.plugin.remotese.transport.KeypleDtoHelper;
import org.eclipse.keyple.plugin.remotese.transport.factory.ServerNode;
import org.eclipse.keyple.plugin.remotese.transport.impl.java.LocalClient;
import org.eclipse.keyple.plugin.remotese.transport.impl.java.LocalTransportDto;
import org.eclipse.keyple.plugin.remotese.transport.model.KeypleDto;
import org.eclipse.keyple.plugin.remotese.transport.model.TransportDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalServer
implements ServerNode {
    private static final Logger logger = LoggerFactory.getLogger(LocalServer.class);
    private LocalClient theClient;
    private DtoHandler dtoHandler;

    public void onLocalMessage(TransportDto transportDto) {
        this.theClient = ((LocalTransportDto)transportDto).getTheClient();
        if (this.dtoHandler == null) {
            throw new IllegalStateException("no DtoHanlder defined");
        }
        TransportDto response = this.dtoHandler.onDTO(new LocalTransportDto(transportDto.getKeypleDTO(), this.theClient));
        this.sendDTO(response);
    }

    @Override
    public void start() {
        logger.info("Local server start");
    }

    @Override
    public void setDtoHandler(DtoHandler handler) {
        this.dtoHandler = handler;
    }

    @Override
    public void sendDTO(TransportDto transportDto) {
        if (KeypleDtoHelper.isNoResponse(transportDto.getKeypleDTO()).booleanValue()) {
            logger.trace("Keyple DTO is empty, do not send it");
        } else {
            this.theClient.onLocalMessage(transportDto.getKeypleDTO());
        }
    }

    @Override
    public void sendDTO(KeypleDto keypleDto) {
        if (KeypleDtoHelper.isNoResponse(keypleDto).booleanValue()) {
            logger.trace("Keyple DTO is empty, do not send it");
        } else {
            this.theClient.onLocalMessage(keypleDto);
        }
    }

    @Override
    public String getNodeId() {
        return "localServer1";
    }
}

