/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: NamespaceDefinition.java,v 1.1 2007/03/18 08:10:11 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfweb;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Namespace Definition</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition#getNamespacePrefix <em>namespacePrefix</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition#getNamespace <em>namespace</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getNamespaceDefinition()
 * @model
 * @generated
 */
public interface NamespaceDefinition extends EObject {
	/**
	 * Returns the value of the '<em><b>namespacePrefix</b></em>' attribute.
	 * The default value is <code>""</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Namespace Prefix</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>namespacePrefix</em>' attribute.
	 * @see #setNamespacePrefix(String)
	 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getNamespaceDefinition_NamespacePrefix()
	 * @model default="" required="true"
	 * @generated
	 */
	String getNamespacePrefix();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition#getNamespacePrefix <em>namespacePrefix</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>namespacePrefix</em>' attribute.
	 * @see #getNamespacePrefix()
	 * @generated
	 */
	void setNamespacePrefix(String value);

	/**
	 * Returns the value of the '<em><b>namespace</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Namespace</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>namespace</em>' reference.
	 * @see #setNamespace(Namespace)
	 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getNamespaceDefinition_Namespace()
	 * @model required="true"
	 * @generated
	 */
	Namespace getNamespace();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition#getNamespace <em>namespace</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>namespace</em>' reference.
	 * @see #getNamespace()
	 * @generated
	 */
	void setNamespace(Namespace value);

} // NamespaceDefinition
