/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: OWL.java,v 1.2 2007/03/18 10:23:38 lzhang Exp $
 */

package org.eclipse.eodm.vocabulary;

/**
 * OWL vocabulary. The builtin vocabulary for OWL all comes from the OWL
 * namespace:OWL_NAMESPACE.
 * <p>
 * OWL Content: An OWL document consists of optional <b>ontology headers
 * </b>(generally at most one) plus any number of <b>class axioms </b>,
 * <b>property axioms </b>, and <b>facts </b> about individuals.
 * <p>
 * The OWL vocabulary is defined by <a
 * href="http://www.w3.org/TR/owl-ref/#appA">OWL Reference </a>
 *  
 */
public final class OWL {
    private OWL() {
    }

    /** The OWL namespace uri */
    public static final String NAMESPACE_URI = "http://www.w3.org/2002/07/owl#";



    /* 1. Classes */
    /* 1.1 Class names */
    public static final String ONTOLOGY = "Ontology";

    public static final String CLASS = "Class";

    public static final String DEPRECATED_CLASS = "DeprecatedClass";

    public static final String RESTRICTION = "Restriction";

    public static final String OBJECT_PROPERTY = "ObjectProperty";

    public static final String DATATYPE_PROPERTY = "DatatypeProperty";

    public static final String DEPRECATED_PROPERTY = "DeprecatedProperty";

    public static final String FUNCTIONAL_PROPERTY = "FunctionalProperty";

    public static final String INVERSE_FUNCTIONAL_PROPERTY = "InverseFunctionalProperty";

    public static final String SYMMETRIC_PROPERTY = "SymmetricProperty";

    public static final String TRANSITIVE_PROPERTY = "TransitiveProperty";

    public static final String THING = "Thing";

    public static final String NOTHING = "Nothing";

    public static final String ALL_DIFFERENT = "AllDifferent";

    public static final String DATA_RANGE = "DataRange";

    public static final String ONTOLOGY_PROPERTY = "OntologyProperty";

    public static final String ANNOTATION_PROPERTY = "AnnotationProperty";

    /* 1.2 Class uris */
    public static final String ONTOLOGY_URI = NAMESPACE_URI + ONTOLOGY;

    public static final String CLASS_URI = NAMESPACE_URI + CLASS;

    public static final String DEPRECATED_CLASS_URI = NAMESPACE_URI
                                                      + DEPRECATED_CLASS;

    public static final String RESTRICTION_URI = NAMESPACE_URI + RESTRICTION;

    public static final String OBJECT_PROPERTY_URI = NAMESPACE_URI
                                                     + OBJECT_PROPERTY;

    public static final String DATATYPE_PROPERTY_URI = NAMESPACE_URI
                                                       + DATATYPE_PROPERTY;

    public static final String DEPRECATED_PROPERTY_URI = NAMESPACE_URI
                                                         + DEPRECATED_PROPERTY;

    public static final String FUNCTIONAL_PROPERTY_URI = NAMESPACE_URI
                                                         + FUNCTIONAL_PROPERTY;

    public static final String INVERSE_FUNCTIONAL_PROPERTY_URI = NAMESPACE_URI
                                                                 + INVERSE_FUNCTIONAL_PROPERTY;

    public static final String SYMMETRIC_PROPERTY_URI = NAMESPACE_URI
                                                        + SYMMETRIC_PROPERTY;

    public static final String TRANSITIVE_PROPERTY_URI = NAMESPACE_URI
                                                         + TRANSITIVE_PROPERTY;

    public static final String THING_URI = NAMESPACE_URI + THING;

    public static final String NOTHING_URI = NAMESPACE_URI + NOTHING;

    public static final String ALL_DIFFERENT_URI = NAMESPACE_URI
                                                   + ALL_DIFFERENT;

    public static final String DATA_RANGE_URI = NAMESPACE_URI + DATA_RANGE;

    public static final String ONTOLOGY_PROPERTY_URI = NAMESPACE_URI
                                                       + ONTOLOGY_PROPERTY;

    public static final String ANNOTATION_PROPERTY_URI = NAMESPACE_URI
                                                         + ANNOTATION_PROPERTY;
    /* 2. Properties */
    /* 2.1 Property names */
    public static final String ONE_OF = "oneOf";

    public static final String SAME_AS = "sameAs";

    public static final String ON_PROPERTY = "onProperty";

    public static final String HAS_VALUE = "hasValue";

    public static final String ALL_VALUES_FROM = "allValuesFrom";

    public static final String SOME_VALUES_FROM = "someValuesFrom";

    public static final String CARDINALITY = "cardinality";

    public static final String MAX_CARDINALITY = "maxCardinality";

    public static final String MIN_CARDINALITY = "minCardinality";

    public static final String INTERSECTION_OF = "intersectionOf";

    public static final String UNION_OF = "unionOf";

    public static final String COMPLEMENT_OF = "complementOf";

    public static final String EQUIVALENT_CLASS = "equivalentClass";

    public static final String EQUIVALENT_PROPERTY = "equivalentProperty";

    public static final String INVERSE_OF = "inverseOf";

    public static final String DISJOINT_WITH = "disjointWith";

    public static final String DIFFERENT_FROM = "differentFrom";

    public static final String DISTINCT_MEMBERS = "distinctMembers";

    public static final String IMPORTS = "imports";

    public static final String VERSION_INFO = "versionInfo";

    public static final String PRIOR_VERSION = "priorVersion";

    public static final String BACKWARD_COMPATIBLE_WITH = "backwardCompatibleWith";

    public static final String INCOMPATIBLE_WITH = "incompatibleWith";

    /* 2.2 Property uris */
    public static final String ONE_OF_URI = NAMESPACE_URI + ONE_OF;

    public static final String SAME_AS_URI = NAMESPACE_URI + SAME_AS;

    public static final String ON_PROPERTY_URI = NAMESPACE_URI + ON_PROPERTY;

    public static final String HAS_VALUE_URI = NAMESPACE_URI + HAS_VALUE;

    public static final String ALL_VALUES_FROM_URI = NAMESPACE_URI
                                                     + ALL_VALUES_FROM;

    public static final String SOME_VALUES_FROM_URI = NAMESPACE_URI
                                                      + SOME_VALUES_FROM;

    public static final String CARDINALITY_URI = NAMESPACE_URI + CARDINALITY;

    public static final String MAX_CARDINALITY_URI = NAMESPACE_URI
                                                     + MAX_CARDINALITY;

    public static final String MIN_CARDINALITY_URI = NAMESPACE_URI
                                                     + MIN_CARDINALITY;

    public static final String INTERSECTION_OF_URI = NAMESPACE_URI
                                                     + INTERSECTION_OF;

    public static final String UNION_OF_URI = NAMESPACE_URI + UNION_OF;

    public static final String COMPLEMENT_OF_URI = NAMESPACE_URI
                                                   + COMPLEMENT_OF;

    public static final String EQUIVALENT_CLASS_URI = NAMESPACE_URI
                                                      + EQUIVALENT_CLASS;

    public static final String EQUIVALENT_PROPERTY_URI = NAMESPACE_URI
                                                         + EQUIVALENT_PROPERTY;

    public static final String INVERSE_OF_URI = NAMESPACE_URI + INVERSE_OF;

    public static final String DISJOINT_WITH_URI = NAMESPACE_URI
                                                   + DISJOINT_WITH;

    public static final String DIFFERENT_FROM_URI = NAMESPACE_URI
                                                    + DIFFERENT_FROM;

    public static final String DISTINCT_MEMBERS_URI = NAMESPACE_URI
                                                      + DISTINCT_MEMBERS;

    public static final String IMPORTS_URI = NAMESPACE_URI + IMPORTS;

    public static final String VERSION_INFO_URI = NAMESPACE_URI + VERSION_INFO;

    public static final String PRIOR_VERSION_URI = NAMESPACE_URI
                                                   + PRIOR_VERSION;

    public static final String BACKWARD_COMPATIBLE_WITH_URI = NAMESPACE_URI
                                                              + BACKWARD_COMPATIBLE_WITH;

    public static final String INCOMPATIBLE_WITH_URI = NAMESPACE_URI
                                                       + INCOMPATIBLE_WITH;

}