/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IRunnable;
import org.eclipse.oomph.util.UserCallback;
import org.eclipse.swt.widgets.Shell;

public class UICallback
extends UserCallback {
    private final Shell shell;
    private final String shellText;

    public UICallback(Shell shell, String shellText) {
        this.shell = shell;
        this.shellText = shellText;
    }

    public Shell getShell() {
        return this.shell;
    }

    public String getShellText() {
        return this.shellText;
    }

    public void execInUI(boolean async, Runnable runnable) {
        UIUtil.exec(this.shell.getDisplay(), async, runnable);
    }

    public boolean runInProgressDialog(boolean async, final IRunnable runnable) {
        final IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                runnable.run(monitor);
            }
        };
        UIUtil.exec(this.shell.getDisplay(), async, new Runnable(){

            public void run() {
                try {
                    UIUtil.runInProgressDialog(UICallback.this.shell, runnableWithProgress);
                }
                catch (InvocationTargetException ex) {
                    UIUtil.handleException(ex.getCause());
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        return false;
    }

    public void information(boolean async, final String message) {
        UIUtil.exec(this.shell.getDisplay(), async, new Runnable(){

            public void run() {
                MessageDialog.openInformation(null, (String)UICallback.this.shellText, (String)message);
            }
        });
    }

    public boolean question(final String message) {
        final AtomicBoolean result = new AtomicBoolean();
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                boolean confirmation = MessageDialog.openQuestion(null, (String)UICallback.this.shellText, (String)message);
                result.set(confirmation);
            }
        });
        return result.get();
    }
}

