/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.URIValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class CursorManager
extends AbstractValueManager {
    protected static final StringMap values = new StringMap();

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 21;
    }

    @Override
    public String getPropertyName() {
        return "cursor";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.AUTO_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        ListValue listValue = new ListValue();
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 24: {
                do {
                    listValue.append(new URIValue(lexicalUnit.getStringValue(), CursorManager.resolveURI(cSSEngine.getCSSBaseURI(), lexicalUnit.getStringValue())));
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    if (lexicalUnit == null) {
                        throw this.createMalformedLexicalUnitDOMException();
                    }
                    if (lexicalUnit.getLexicalUnitType() != 0) {
                        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                    }
                    if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null) continue;
                    throw this.createMalformedLexicalUnitDOMException();
                } while (lexicalUnit.getLexicalUnitType() == 24);
                if (lexicalUnit.getLexicalUnitType() != 35) {
                    throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                }
            }
            case 35: {
                String string = lexicalUnit.getStringValue().toLowerCase().intern();
                Object object = values.get(string);
                if (object == null) {
                    throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
                }
                listValue.append((Value)object);
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            }
        }
        if (lexicalUnit != null) {
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        }
        return listValue;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getCssValueType() == 2) {
            ListValue listValue = (ListValue)value;
            int n2 = listValue.getLength();
            ListValue listValue2 = new ListValue(' ');
            for (int i = 0; i < n2; ++i) {
                Value value2 = listValue.item(0);
                if (value2.getPrimitiveType() == 20) {
                    listValue2.append(new URIValue(value2.getStringValue(), value2.getStringValue()));
                    continue;
                }
                listValue2.append(value2);
            }
            return listValue2;
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }

    static {
        values.put("auto", ValueConstants.AUTO_VALUE);
        values.put("crosshair", ValueConstants.CROSSHAIR_VALUE);
        values.put("default", ValueConstants.DEFAULT_VALUE);
        values.put("e-resize", ValueConstants.E_RESIZE_VALUE);
        values.put("help", ValueConstants.HELP_VALUE);
        values.put("move", ValueConstants.MOVE_VALUE);
        values.put("n-resize", ValueConstants.N_RESIZE_VALUE);
        values.put("ne-resize", ValueConstants.NE_RESIZE_VALUE);
        values.put("nw-resize", ValueConstants.NW_RESIZE_VALUE);
        values.put("pointer", ValueConstants.POINTER_VALUE);
        values.put("s-resize", ValueConstants.S_RESIZE_VALUE);
        values.put("se-resize", ValueConstants.SE_RESIZE_VALUE);
        values.put("sw-resize", ValueConstants.SW_RESIZE_VALUE);
        values.put("text", ValueConstants.TEXT_VALUE);
        values.put("w-resize", ValueConstants.W_RESIZE_VALUE);
        values.put("wait", ValueConstants.WAIT_VALUE);
    }
}

