/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.resource;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.RootXMLContentHandlerImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypeDocumentRoot;

public class AnyRootNamespaceContentHandler
extends RootXMLContentHandlerImpl {
    public AnyRootNamespaceContentHandler(Map<String, String> parameters) {
        super(parameters);
    }

    public AnyRootNamespaceContentHandler(String contentTypeID, String[] extensions, String namespace) {
        super(contentTypeID, extensions, null, namespace, null);
    }

    public AnyRootNamespaceContentHandler(String contentTypeID, String[] extensions, Pattern namespacePattern) {
        super(contentTypeID, extensions, null, namespacePattern, null);
    }

    public Map<String, Object> contentDescription(URI uri, InputStream inputStream, Map<?, ?> options, Map<Object, Object> context) throws IOException {
        Map result;
        String contentType = this.contentTypeID;
        try {
            EObject eObject;
            result = super.contentDescription(uri, inputStream, options, context);
            XMLResource xmlResource = this.load(uri, inputStream, options, context);
            EList contents = xmlResource.getContents();
            if (!contents.isEmpty() && (eObject = (EObject)contents.get(0)) instanceof XMLTypeDocumentRoot) {
                String matchedNamespace = null;
                XMLTypeDocumentRoot documentRoot = (XMLTypeDocumentRoot)eObject;
                for (String next : documentRoot.getXMLNSPrefixMap().values()) {
                    if (!this.isMatchingNamespace(next)) continue;
                    matchedNamespace = next;
                    break;
                }
                if (matchedNamespace != null) {
                    result.put("org.eclipse.emf.ecore:validity", ContentHandler.Validity.VALID);
                } else {
                    result.put("org.eclipse.emf.ecore:validity", ContentHandler.Validity.INVALID);
                }
                if (contentType == null) {
                    contentType = matchedNamespace;
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Uncaught exception in describing resource content.", e);
        }
        result.put("org.eclipse.emf.ecore:contentType", Strings.nullToEmpty((String)contentType));
        return result;
    }

    public static class Describer
    extends RootXMLContentHandlerImpl.Describer {
        protected ContentHandler createContentHandler(Map<String, String> parameters) {
            return new AnyRootNamespaceContentHandler(parameters);
        }
    }
}

