/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import org.eclipse.papyrus.infra.nattable.handler.AbstractTreeTableHandler;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;

public abstract class AbstractTreeRowHideShowCategoryHandler
extends AbstractTreeTableHandler {
    protected boolean allCategoriesAreCurrentlyHidden() {
        Table table = this.getTable();
        IntListValueStyle values = (IntListValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getIntListValueStyle(), "hiddenCategoriesByDepth");
        if (values == null) {
            return false;
        }
        int maxDepth = FillingConfigurationUtils.getMaxDepthForTree(this.getTable());
        return values.getIntListValue().size() == maxDepth + 1;
    }

    protected boolean allCategoriesAreCurrentlyVisible() {
        Table table = this.getTable();
        IntListValueStyle values = (IntListValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getIntListValueStyle(), "hiddenCategoriesByDepth");
        return values == null || values.getIntListValue().isEmpty();
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        if (this.isEnabled() && FillingConfigurationUtils.getAllTreeFillingConfiguration(this.getTable()).size() == 0) {
            this.setBaseEnabled(false);
        }
    }
}

