/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.menu;

import java.lang.constant.Constable;
import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class ShowHideCategoriesContributionItem
extends ContributionItem {
    public ShowHideCategoriesContributionItem() {
    }

    public ShowHideCategoriesContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        Control control;
        ICommandService serv = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = serv.getCommand("org.eclipse.papyrus.infra.nattable.row.show.hide.category.command");
        if (command.isEnabled() && (control = Display.getDefault().getCursorControl()) instanceof NatTable) {
            this.addShowHideCategoryCommandToMenu(menu, command, (NatTable)control);
        }
    }

    private void addShowHideCategoryCommandToMenu(Menu menu, final Command command, NatTable natTable) {
        Table table = this.getTable(natTable);
        int maxDepth = FillingConfigurationUtils.getMaxDepthForTree(table);
        int min = 0;
        if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(table, 0)) {
            ++min;
        }
        final IHandler handler = command.getHandler();
        int depth = min;
        while (depth <= maxDepth) {
            MenuItem item = new MenuItem(menu, 32);
            final boolean isHidden = this.isHidden(table, depth);
            item.setSelection(!isHidden);
            String text = null;
            text = NLS.bind((String)Messages.PapyrusPopupMenuAction_ShowCategoriesOnDepth, (Object)depth);
            item.setText(text);
            final Integer index = depth;
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    HashMap<String, Constable> parameters = new HashMap<String, Constable>();
                    parameters.put("depth", index);
                    parameters.put("hideCategory", Boolean.valueOf(!isHidden));
                    try {
                        handler.execute(new ExecutionEvent(command, parameters, null, null));
                    }
                    catch (ExecutionException e) {
                        Activator.log.error((Throwable)e);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            ++depth;
        }
    }

    private Table getTable(NatTable natTable) {
        IConfigRegistry configRegistry = natTable.getConfigRegistry();
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        return modelManager.getTable();
    }

    private boolean isHidden(Table table, int depth) {
        return StyleUtils.getHiddenDepths(table).contains(depth);
    }
}

