/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.exporter;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.cdo.core.exporter.IModelExportMapping;
import org.eclipse.papyrus.cdo.core.exporter.IModelExporter;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferNode;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferOperation;
import org.eclipse.papyrus.cdo.internal.core.CDOProxyResolvingResourceSet;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.core.l10n.Messages;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public class ModelExporter
implements IModelExporter {
    @Override
    public Diagnostic exportModels(final IModelExportMapping mapping) {
        BasicDiagnostic result = new BasicDiagnostic();
        ModelExporter.add((DiagnosticChain)result, mapping.getConfiguration().validate());
        ModelExporter.add((DiagnosticChain)result, mapping.validate());
        if (result.getSeverity() < 4) {
            ModelExporter.add((DiagnosticChain)result, mapping.getConfiguration().getOperationContext().run(new IModelTransferOperation(){

                @Override
                public Diagnostic run(IProgressMonitor monitor) {
                    return ModelExporter.this.doExport(mapping, monitor);
                }
            }));
        }
        return result;
    }

    protected Diagnostic doExport(IModelExportMapping mapping, IProgressMonitor monitor) {
        BasicDiagnostic result = new BasicDiagnostic();
        IModelTransferConfiguration configuration = mapping.getConfiguration();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ModelExporter_0, (int)(2 * configuration.getModelsToTransfer().size() + 3));
        CDOCheckout checkout = mapping.getCheckout();
        CDOTransaction transaction = checkout.openTransaction((ResourceSet)new CDOProxyResolvingResourceSet());
        ResourceSet source = transaction.getResourceSet();
        ResourceSetImpl destination = new ResourceSetImpl();
        try {
            for (IModelTransferNode model : configuration.getModelsToTransfer()) {
                ModelExporter.add((DiagnosticChain)result, this.loadModel(model, (CDOView)transaction, (IProgressMonitor)sub.newChild(1)));
            }
            EcoreUtil.resolveAll((ResourceSet)source);
            sub.worked(1);
            for (IModelTransferNode model : configuration.getModelsToTransfer()) {
                ModelExporter.add((DiagnosticChain)result, this.exportModel(model, (CDOView)transaction, mapping.getMapping(model), (ResourceSet)destination, (IProgressMonitor)sub.newChild(1)));
            }
            for (IModelTransferNode model : configuration.getModelsToTransfer()) {
                ModelExporter.add((DiagnosticChain)result, this.saveModel(model, (CDOView)transaction, mapping.getMapping(model), (ResourceSet)destination));
            }
            sub.worked(1);
        }
        finally {
            EMFHelper.unload((ResourceSet)destination);
            CDOUtils.unload((CDOView)transaction);
            transaction.close();
            EMFHelper.unload((ResourceSet)source);
            sub.worked(1);
        }
        sub.done();
        return result;
    }

    protected Diagnostic loadModel(IModelTransferNode model, CDOView view, IProgressMonitor monitor) {
        BasicDiagnostic result = new BasicDiagnostic();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)model.getName(), (int)model.getResourceURIs().size());
        for (URI next : model.getResourceURIs()) {
            Resource source = view.getResourceSet().getResource(next, true);
            Iterator iter = source.getContents().iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            sub.worked(1);
        }
        sub.done();
        return result;
    }

    protected Diagnostic exportModel(IModelTransferNode model, CDOView view, IPath toPath, ResourceSet rset, IProgressMonitor monitor) {
        BasicDiagnostic result = new BasicDiagnostic();
        IPath basePath = toPath.removeFileExtension();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)model.getName(), (int)model.getResourceURIs().size());
        for (URI next : model.getResourceURIs()) {
            Resource source = view.getResourceSet().getResource(next, true);
            Resource destination = rset.createResource(URI.createPlatformResourceURI((String)basePath.addFileExtension(next.fileExtension()).toString(), (boolean)true));
            ModelExporter.add((DiagnosticChain)result, this.exportResource(source, destination));
            sub.worked(1);
        }
        sub.done();
        return result;
    }

    protected Diagnostic exportResource(Resource source, Resource destination) {
        destination.getContents().addAll((Collection)source.getContents());
        return Diagnostic.OK_INSTANCE;
    }

    protected Diagnostic saveModel(IModelTransferNode model, CDOView view, IPath toPath, ResourceSet rset) {
        BasicDiagnostic result = new BasicDiagnostic();
        IPath basePath = toPath.removeFileExtension();
        for (URI next : model.getResourceURIs()) {
            Resource destination = rset.getResource(URI.createPlatformResourceURI((String)basePath.addFileExtension(next.fileExtension()).toString(), (boolean)true), false);
            try {
                destination.save(null);
            }
            catch (Exception e) {
                ModelExporter.add((DiagnosticChain)result, (Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, Messages.ModelExporter_1, new Object[]{e}));
            }
        }
        return result;
    }

    private static void add(DiagnosticChain diagnostics, Diagnostic diagnostic) {
        if (diagnostic.getSeverity() > 0) {
            diagnostics.merge(diagnostic);
        }
    }
}

