/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.assuranceproject.utils;

import java.util.ArrayList;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class ListAssuranceProject
extends Dialog {
    private static final String ASSURANCEPROJECT = ".assuranceproject";
    private CDOView viewCDO = null;
    protected ArrayList<String> sResult = null;
    protected List refList;
    protected ArrayList<String> refListDirMap;
    protected boolean bcheck = true;

    public ListAssuranceProject(Shell parentShell, CDOSession sessionCDO) {
        super(parentShell);
        this.viewCDO = CDOConnectionUtil.instance.openView(sessionCDO);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public ListAssuranceProject(IShellProvider parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 1;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        Label idLabel = new Label(contents, 0);
        idLabel.setText("Select source assurance project:");
        GridData idLabelGridData = new GridData();
        idLabelGridData.horizontalAlignment = 4;
        idLabelGridData.verticalAlignment = 4;
        idLabel.setLayoutData((Object)idLabelGridData);
        this.refList = new List(contents, 2820);
        this.refList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.refListDirMap = new ArrayList();
        CDOResourceNode[] listR = (CDOResourceNode[])this.viewCDO.getElements();
        int i = 0;
        while (i < listR.length) {
            if (listR[i] instanceof CDOResourceFolder) {
                this.checkFolderContents((CDOResourceFolder)listR[i], ASSURANCEPROJECT);
            } else if (listR[i].getName().endsWith(ASSURANCEPROJECT)) {
                this.refList.add(listR[i].getName());
                this.refListDirMap.add(listR[i].getPath());
            }
            ++i;
        }
        return contents;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("List Source Assurance Projects");
    }

    protected void okPressed() {
        if (this.refList.getSelectionCount() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Select source assurance project", (String)"It's neccesary to select a project.");
        } else if (this.refList.getSelectionCount() != 1) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Select source assurance project", (String)"It's neccesary to select only one project.");
        } else {
            int i = this.refList.getSelectionIndex();
            String sSelectedProject = this.refList.getItem(i);
            this.sResult = new ArrayList();
            this.sResult.add(sSelectedProject);
            this.sResult.add(this.refListDirMap.get(this.refList.getSelectionIndex()));
            super.okPressed();
        }
    }

    public boolean close() {
        return super.close();
    }

    public ArrayList<String> getResult() {
        return this.sResult;
    }

    private void checkFolderContents(CDOResourceFolder cdoResourceFolder, String sCadena) {
        EList listN = cdoResourceFolder.getNodes();
        int i = 0;
        while (i < listN.size()) {
            if (listN.get(i) instanceof CDOResourceFolder) {
                this.checkFolderContents((CDOResourceFolder)listN.get(i), sCadena);
            } else if (((CDOResourceNode)listN.get(i)).getName().endsWith(sCadena)) {
                this.refList.add(((CDOResourceNode)listN.get(i)).getName());
                this.refListDirMap.add(((CDOResourceNode)listN.get(i)).getPath());
            }
            ++i;
        }
    }
}

