/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.autocomplete;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.opencert.userguidance.autocomplete.ContentProposalAdapter2;
import org.eclipse.opencert.userguidance.autocomplete.ContentProposalListener;
import org.eclipse.opencert.userguidance.autocomplete.ProposalLabelProvider;
import org.eclipse.opencert.userguidance.autocomplete.proposalproviders.IdProposalProvider;
import org.eclipse.opencert.userguidance.autocomplete.proposalproviders.VocabularyProposalProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;

public class AutoCompleteField2 {
    private ContentProposalAdapter2 proposalAdapter;

    public AutoCompleteField2(StyledText control, IControlContentAdapter controlContentAdapter, EObject eobj, int featureID) {
        ParentProposalProvider parentProposalProvider = new ParentProposalProvider();
        for (IContentProposalProvider child : this.createChildrenProposalProviders(eobj, featureID)) {
            parentProposalProvider.add(child);
        }
        this.configureControlContentAdapter(control, controlContentAdapter, parentProposalProvider);
    }

    public boolean isPopupOpen() {
        if (this.proposalAdapter != null) {
            return this.proposalAdapter.isProposalPopupOpen();
        }
        return false;
    }

    private List<IContentProposalProvider> createChildrenProposalProviders(EObject eobj, int featureID) {
        ArrayList<IContentProposalProvider> result = new ArrayList<IContentProposalProvider>();
        result.add(new VocabularyProposalProvider(eobj, featureID));
        result.add(new IdProposalProvider(eobj, featureID));
        return result;
    }

    private void configureControlContentAdapter(StyledText control, IControlContentAdapter controlContentAdapter, ParentProposalProvider parentProposalProvider) {
        KeyStroke keyStroke = null;
        try {
            keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
        }
        catch (ParseException parseException) {}
        this.proposalAdapter = new ContentProposalAdapter2((Control)control, controlContentAdapter, parentProposalProvider, keyStroke, null);
        this.proposalAdapter.setPropagateKeys(true);
        this.proposalAdapter.setProposalAcceptanceStyle(3);
        this.proposalAdapter.addContentProposalListener(new ContentProposalListener(control));
        this.proposalAdapter.setLabelProvider(new ProposalLabelProvider());
    }

    private class ParentProposalProvider
    implements IContentProposalProvider {
        private List<IContentProposalProvider> children = new ArrayList<IContentProposalProvider>();

        public void add(IContentProposalProvider child) {
            this.children.add(child);
        }

        public IContentProposal[] getProposals(String contents, int caretOffset) {
            ArrayList<IContentProposal[]> allProposals = new ArrayList<IContentProposal[]>();
            int totalProposalSize = 0;
            int i = 0;
            while (i < this.children.size()) {
                IContentProposal[] childProposals = this.children.get(i).getProposals(contents, caretOffset);
                allProposals.add(childProposals);
                totalProposalSize += childProposals.length;
                ++i;
            }
            IContentProposal[] result = new IContentProposal[totalProposalSize];
            int i2 = 0;
            int j = 0;
            while (j < allProposals.size()) {
                IContentProposal[] proposals = (IContentProposal[])allProposals.get(j);
                int k = 0;
                while (k < proposals.length) {
                    result[i2] = proposals[k];
                    ++k;
                    ++i2;
                }
                ++j;
            }
            return result;
        }
    }
}

