/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.baseline.baseline.diagram.edit.commands;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;
import org.eclipse.opencert.apm.baseline.baseline.BaselinePackage;
import org.eclipse.opencert.infra.general.general.NamedElement;
import org.eclipse.opencert.pkm.refframework.refframework.RefframeworkPackage;

public class LoadViewLocations {
    private CDOResource sourceFile;
    Map<String, LayoutConstraint> objectLocations = new HashMap<String, LayoutConstraint>();

    public LoadViewLocations(CDOResource sourceFile) {
        this.sourceFile = sourceFile;
    }

    private String traducir(String claseRef) {
        String ret = "";
        if (claseRef.contains(RefframeworkPackage.eINSTANCE.getRefActivity().getName())) {
            ret = BaselinePackage.eINSTANCE.getBaseActivity().getName();
        } else if (claseRef.contains(RefframeworkPackage.eINSTANCE.getRefArtefact().getName())) {
            ret = BaselinePackage.eINSTANCE.getBaseArtefact().getName();
        } else if (claseRef.contains(RefframeworkPackage.eINSTANCE.getRefRole().getName())) {
            ret = BaselinePackage.eINSTANCE.getBaseRole().getName();
        }
        return ret;
    }

    private void LoadChildrenLocations(Object editPart0) {
        if (editPart0 == null) {
            return;
        }
        Node editPart = (Node)editPart0;
        for (Object child : editPart.getChildren()) {
            if (!(child instanceof Node)) continue;
            this.LoadChildrenLocations(child);
        }
        if (editPart instanceof Node) {
            Node node = editPart;
            LayoutConstraint lc = node.getLayoutConstraint();
            NamedElement me = (NamedElement)node.getElement();
            System.out.println("LoadChildrenLocations key = " + me.getId() + me.getName() + me.getClass().getName());
            this.objectLocations.put(String.valueOf(me.getId()) + me.getName() + this.traducir(me.eClass().getName()), lc);
        }
    }

    public void LoadObjectLocations() {
        CDOResource aa = this.sourceFile;
        DiagramImpl d = (DiagramImpl)aa.getContents().get(0);
        for (Object elem0 : d.getChildren()) {
            if (!(elem0 instanceof Node)) continue;
            Node view = (Node)elem0;
            view.getLayoutConstraint();
            NamedElement me = (NamedElement)view.getElement();
            System.out.println("LoadObjectLocations key = " + me.getId() + me.getName() + me.getClass().getName());
            this.LoadChildrenLocations(elem0);
        }
    }

    public LayoutConstraint getObjectLocation(String key) {
        return this.objectLocations.get(key);
    }
}

