/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.TimeTypesLibrary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TimeInterpretationKind implements Enumerator
{
    DURATION(0, "duration", "duration"),
    INSTANT(1, "instant", "instant");

    public static final int DURATION_VALUE = 0;
    public static final int INSTANT_VALUE = 1;
    private static final TimeInterpretationKind[] VALUES_ARRAY;
    public static final List<TimeInterpretationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimeInterpretationKind[]{DURATION, INSTANT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TimeInterpretationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeInterpretationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeInterpretationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeInterpretationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeInterpretationKind get(int value) {
        switch (value) {
            case 0: {
                return DURATION;
            }
            case 1: {
                return INSTANT;
            }
        }
        return null;
    }

    private TimeInterpretationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

