/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.TimeTypesLibrary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TimeNatureKind implements Enumerator
{
    DISCRETE(0, "discrete", "discrete"),
    DENSE(1, "dense", "dense");

    public static final int DISCRETE_VALUE = 0;
    public static final int DENSE_VALUE = 1;
    private static final TimeNatureKind[] VALUES_ARRAY;
    public static final List<TimeNatureKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimeNatureKind[]{DISCRETE, DENSE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TimeNatureKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeNatureKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeNatureKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeNatureKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeNatureKind get(int value) {
        switch (value) {
            case 0: {
                return DISCRETE;
            }
            case 1: {
                return DENSE;
            }
        }
        return null;
    }

    private TimeNatureKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

