/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.storage.cdo.test;

import java.util.Date;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssetsPackage;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceProject;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceprojectFactory;
import org.eclipse.opencert.apm.assurproj.assuranceproject.BaselineConfig;
import org.eclipse.opencert.evm.evidspec.evidence.Artefact;
import org.eclipse.opencert.evm.evidspec.evidence.ArtefactDefinition;
import org.eclipse.opencert.evm.evidspec.evidence.ArtefactModel;
import org.eclipse.opencert.evm.evidspec.evidence.ArtefactRel;
import org.eclipse.opencert.evm.evidspec.evidence.EvidenceFactory;
import org.eclipse.opencert.infra.general.general.ChangeEffectKind;
import org.eclipse.opencert.pam.procspec.process.Activity;
import org.eclipse.opencert.pam.procspec.process.Organization;
import org.eclipse.opencert.pam.procspec.process.Person;
import org.eclipse.opencert.pam.procspec.process.ProcessFactory;
import org.eclipse.opencert.pam.procspec.process.ProcessModel;
import org.eclipse.opencert.sam.arg.arg.ArgFactory;
import org.eclipse.opencert.sam.arg.arg.Case;
import org.eclipse.opencert.storage.cdo.test.DataCreationRoutines;

public class SampleDataProvider {
    private static final int ACTIVITIES_PER_PERSON = 1;
    private static final int PEOPLE_PER_ORGANIZATION = 1;
    private static final int ORGANIZATIONS_COUNT = 1;
    private static final int PART_ARTEFACTS_COUNT = 1;
    private static final int COUNT = 20000;

    public static void populateWithArtefactHierarchy(Resource resource) {
        int artefactId = 20000;
        int artefactRelId = 20000;
        ArtefactModel artefactModel = EvidenceFactory.eINSTANCE.createArtefactModel();
        artefactModel.setId("id_100000");
        artefactModel.setName("artefactModel with " + artefactModel.getId());
        ArtefactDefinition artefactDef = EvidenceFactory.eINSTANCE.createArtefactDefinition();
        ProcessModel processModel = ProcessFactory.eINSTANCE.createProcessModel();
        processModel.setId("id_100000");
        processModel.setName("processModel with " + processModel.getId());
        int organizationNr = 20000;
        while (organizationNr < 20001) {
            Organization organization = ProcessFactory.eINSTANCE.createOrganization();
            organization.setId("id_" + organizationNr);
            organization.setAddress("addressOfOrganization" + organizationNr);
            int personNr = 20000;
            while (personNr < 20001) {
                Person person = ProcessFactory.eINSTANCE.createPerson();
                person.setId("id_" + personNr);
                person.setEmail("email" + personNr + "@organization" + organizationNr);
                person.getOrganization().add((Object)organization);
                int activityNr = 0;
                while (activityNr < 1) {
                    Artefact artefact = DataCreationRoutines.createArtefact("artefact with ", artefactId++);
                    int partArtefactNr = 0;
                    while (partArtefactNr < 1) {
                        Artefact artefactPart = DataCreationRoutines.createArtefact("artefactPart with ", artefactId++);
                        resource.getContents().add((Object)artefactPart);
                        artefact.getArtefactPart().add((Object)artefactPart);
                        ++partArtefactNr;
                    }
                    resource.getContents().add((Object)artefact);
                    int k = 0;
                    while (k < 2) {
                        Artefact sourceArtefact = DataCreationRoutines.createArtefact("sourceArtefact with ", artefactId++);
                        Artefact targetArtefact = DataCreationRoutines.createArtefact("targetArtefact with ", artefactId++);
                        ArtefactRel artefactRel = EvidenceFactory.eINSTANCE.createArtefactRel();
                        artefactRel.setId("id_" + artefactRelId++);
                        artefactRel.setName("artefactRel with " + artefactRel.getId());
                        artefactRel.setModificationEffect(ChangeEffectKind.MODIFY);
                        artefactRel.setSource(sourceArtefact);
                        artefactRel.setTarget(targetArtefact);
                        resource.getContents().add((Object)sourceArtefact);
                        resource.getContents().add((Object)targetArtefact);
                        resource.getContents().add((Object)artefactRel);
                        artefact.getOwnedRel().add((Object)artefactRel);
                        ++k;
                    }
                    Activity activity = ProcessFactory.eINSTANCE.createActivity();
                    activity.setStartTime(new Date());
                    activity.getProducedArtefact().add((Object)artefact);
                    activity.setEndTime(new Date());
                    activity.getParticipant().add((Object)person);
                    resource.getContents().add((Object)activity);
                    processModel.getOwnedActivity().add((Object)activity);
                    artefactDef.getArtefact().add((Object)artefact);
                    ++activityNr;
                }
                artefactModel.getArtefact().add((Object)artefactDef);
                resource.getContents().add((Object)person);
                ++personNr;
            }
            resource.getContents().add((Object)organization);
            ++organizationNr;
        }
        resource.getContents().add((Object)artefactDef);
        resource.getContents().add((Object)artefactModel);
        resource.getContents().add((Object)processModel);
    }

    public static void populateAssuranceProject(Resource resource) {
        AssuranceProject assuranceProject = AssuranceprojectFactory.eINSTANCE.createAssuranceProject();
        assuranceProject.setId("AP1");
        assuranceProject.setDescription("AP1");
        assuranceProject.setName("AP1");
        AssetsPackage assetsPackage = AssuranceprojectFactory.eINSTANCE.createAssetsPackage();
        assetsPackage.setIsActive(true);
        assuranceProject.getAssetsPackage().add((Object)assetsPackage);
        BaselineConfig baselineConfig = AssuranceprojectFactory.eINSTANCE.createBaselineConfig();
        baselineConfig.setId("BC1");
        baselineConfig.setDescription("BC1");
        baselineConfig.setName("BC1");
        baselineConfig.setIsActive(true);
        resource.getContents().add((Object)baselineConfig);
        assuranceProject.getBaselineConfig().add((Object)baselineConfig);
        resource.getContents().add((Object)assuranceProject);
    }

    public static void populateArg(Resource resource) {
        Case aCase = ArgFactory.eINSTANCE.createCase();
        resource.getContents().add((Object)aCase);
    }
}

