/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gmf.runtime.emf.type.core.ClientContext;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IAdviceBindingDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.infra.types.core.Activator;

public class ElementTypeRegistryUtils {
    public static IElementType getType(IClientContext context, String elementTypeID) {
        IElementType[] elementTypes;
        IElementType[] iElementTypeArray = elementTypes = ElementTypeRegistry.getInstance().getElementTypes(context);
        int n = elementTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IElementType iElementType = iElementTypeArray[n2];
            if (iElementType.getId().equals(elementTypeID)) {
                return iElementType;
            }
            ++n2;
        }
        return null;
    }

    public static void registerAdviceBinding(IAdviceBindingDescriptor adviceDescriptor) {
        ElementTypeRegistry.getInstance().registerAdvice(adviceDescriptor);
    }

    public static void removeAdviceDescriptorFromBindings(IAdviceBindingDescriptor adviceDescriptor) {
        ElementTypeRegistry.getInstance().deregisterAdvice(adviceDescriptor);
    }

    public static void unBindID(IClientContext context, String typeId) {
        if (context instanceof ClientContext) {
            ((ClientContext)context).unbindId(typeId);
        } else if (context != null) {
            Activator.log.warn("Cannot unbind type ID from context of unknown class: " + context.getClass().getName());
        }
    }

    public static List<IElementType> getElementTypesBySemanticHint(String semanticHint, String contextId) {
        ArrayList<IElementType> matchingElementTypes = new ArrayList<IElementType>();
        IClientContext context = ClientContextManager.getInstance().getClientContext(contextId);
        if (context != null) {
            IElementType[] elementTypes;
            IElementType[] iElementTypeArray = elementTypes = ElementTypeRegistry.getInstance().getElementTypes(context);
            int n = elementTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IElementType iElementType = iElementTypeArray[n2];
                if (iElementType instanceof IHintedType && ((IHintedType)iElementType).getSemanticHint().equals(semanticHint)) {
                    matchingElementTypes.add(iElementType);
                }
                ++n2;
            }
        }
        return matchingElementTypes;
    }
}

