/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.wizards.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.opencert.apm.assurproj.utils.widget.CheckboxTreeViewerExt;
import org.eclipse.opencert.pkm.refframework.refframework.RefActivity;
import org.eclipse.opencert.pkm.refframework.refframework.RefArtefact;
import org.eclipse.opencert.pkm.refframework.refframework.RefFramework;
import org.eclipse.opencert.pkm.refframework.refframework.RefRequirement;
import org.eclipse.opencert.pkm.refframework.refframework.RefRole;
import org.eclipse.opencert.pkm.refframework.refframework.RefTechnique;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AssurProjRefFrameworkSelectionWizardPage
extends WizardPage {
    private static final String OPENCERT_REFFRAMEWORK_DIR_KEY = "OPENCERT_REFFRAMEWORK_DIR_KEY";
    private static final String REFFRAMEWORK = ".refframework";
    private static final String TAILORED_REFFRAMEWORK = "tailoredRefFramework";
    private static final String NAME_FOR_BASELINE = "Name for Baseline:";
    private static final String BASELINE_SELECTION = "Baseline Selection";
    public static final String REFERENCE_FRAMEWORK_SELECTION = "Reference Framework Selection";
    private static final String CHOOSE_ASSOCIATED_REFERENCE_FRAMEWORK = "Choose associated Reference Framework";
    private static final String OPENCERT_REFERENCE_FRAMEWORK_SELECTION = "OPENCERT Reference Framework Selection";
    public static final int CHANGE_EVENT = 7500;
    protected List refList;
    protected ArrayList<String> refListDir;
    protected String qref;
    protected IFile modelFile;
    protected ComposedAdapterFactory adapterFactory;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ResourceSet resourceSet;
    protected CheckboxTreeViewerExt modelViewer;
    private Object[] results;
    private Text baselineName;
    private CDOView viewCDO = null;

    public AssurProjRefFrameworkSelectionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(OPENCERT_REFERENCE_FRAMEWORK_SELECTION);
        this.setMessage(CHOOSE_ASSOCIATED_REFERENCE_FRAMEWORK);
    }

    public AssurProjRefFrameworkSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this.setControl((Control)this.createControls(parent));
    }

    protected Composite createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout1 = new GridLayout(3, true);
        composite.setLayout((Layout)layout1);
        Group group = new Group(composite, 4);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(REFERENCE_FRAMEWORK_SELECTION);
        Composite modelComposite = new Composite((Composite)group, 4);
        modelComposite.setLayout((Layout)new GridLayout(1, false));
        this.refList = new List(modelComposite, 2820);
        this.refList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.refListDir = new ArrayList();
        this.findQRef();
        this.qref = "";
        this.refList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssurProjRefFrameworkSelectionWizardPage.this.qref = AssurProjRefFrameworkSelectionWizardPage.this.refListDir.get(AssurProjRefFrameworkSelectionWizardPage.this.refList.getSelectionIndex()).toString();
                AssurProjRefFrameworkSelectionWizardPage.this.CreateModelFromFile((TreeViewer)AssurProjRefFrameworkSelectionWizardPage.this.modelViewer, AssurProjRefFrameworkSelectionWizardPage.this.qref);
            }
        });
        Group groupReq = new Group(composite, 0);
        groupReq.setLayout((Layout)new GridLayout(1, false));
        groupReq.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        groupReq.setText(BASELINE_SELECTION);
        this.modelViewer = new CheckboxTreeViewerExt((Composite)groupReq, 2818);
        this.modelViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.modelViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.modelViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        ICheckStateListener checkStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object changedElement = event.getElement();
                boolean status = AssurProjRefFrameworkSelectionWizardPage.this.modelViewer.getChecked(changedElement);
                boolean isExpanded = AssurProjRefFrameworkSelectionWizardPage.this.modelViewer.getExpandedState(changedElement);
                AssurProjRefFrameworkSelectionWizardPage.this.modelViewer.expandToLevel(changedElement, -1);
                AssurProjRefFrameworkSelectionWizardPage.this.modelViewer.setSubtreeChecked(changedElement, status);
                if (!isExpanded) {
                    AssurProjRefFrameworkSelectionWizardPage.this.modelViewer.collapseToLevel(changedElement, -1);
                }
                if (status) {
                    AssurProjRefFrameworkSelectionWizardPage.this.modelViewer.setParentsChecked(changedElement, true);
                }
                AssurProjRefFrameworkSelectionWizardPage.this.results = AssurProjRefFrameworkSelectionWizardPage.this.modelViewer.getCheckedElements();
                AssurProjRefFrameworkSelectionWizardPage.this.checkComplete();
            }
        };
        this.modelViewer.addCheckStateListener(checkStateListener);
        Label label1 = new Label(composite, 0);
        label1.setText(NAME_FOR_BASELINE);
        this.baselineName = new Text(composite, 2052);
        this.baselineName.setText(TAILORED_REFFRAMEWORK);
        this.baselineName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AssurProjRefFrameworkSelectionWizardPage.this.checkComplete();
            }
        });
        this.setPageComplete(false);
        return composite;
    }

    public String getBaselineName() {
        return this.baselineName.getText();
    }

    public void checkComplete() {
        if (!this.getBaselineName().equals("") && this.modelViewer.getCheckedElements().length > 0) {
            this.setPageComplete(true);
        }
    }

    public boolean performOk(IProject project, IProgressMonitor monitor) {
        monitor.worked(1);
        return true;
    }

    public int findQRef() {
        int nStandards = 0;
        nStandards = this.addFilesOfDir();
        return nStandards;
    }

    public int addFilesOfDir() {
        int sumStd = 0;
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOSession sessionCDO = CDOConnectionUtil.instance.openSession();
        this.viewCDO = CDOConnectionUtil.instance.openView(sessionCDO);
        CDOResourceNode[] listR = (CDOResourceNode[])this.viewCDO.getElements();
        int i = 0;
        while (i < listR.length) {
            if (listR[i] instanceof CDOResourceFolder) {
                this.checkFolderContents((CDOResourceFolder)listR[i], sumStd);
            } else if (listR[i].getName().endsWith(REFFRAMEWORK)) {
                this.refList.add(listR[i].getPath());
                this.refListDir.add(listR[i].getPath());
                ++sumStd;
            }
            ++i;
        }
        return sumStd;
    }

    private void checkFolderContents(CDOResourceFolder cdoResourceFolder, int sumStd) {
        EList listN = cdoResourceFolder.getNodes();
        int i = 0;
        while (i < listN.size()) {
            if (listN.get(i) instanceof CDOResourceFolder) {
                this.checkFolderContents((CDOResourceFolder)listN.get(i), sumStd);
            } else if (((CDOResourceNode)listN.get(i)).getName().endsWith(REFFRAMEWORK)) {
                this.refList.add(((CDOResourceNode)listN.get(i)).getPath());
                this.refListDir.add(((CDOResourceNode)listN.get(i)).getPath());
                ++sumStd;
            }
            ++i;
        }
    }

    public String getQRef() {
        return this.qref;
    }

    public void CreateModelFromFile(TreeViewer tviewer, String model) {
        if (model != null) {
            CDOResource resource = null;
            try {
                resource = this.viewCDO.getResource(model);
                tviewer.setInput(null);
                tviewer.setInput((Object)resource);
                ViewerFilter modelFilter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof RefFramework) {
                            return true;
                        }
                        if (element instanceof RefActivity) {
                            return true;
                        }
                        if (element instanceof RefArtefact) {
                            return true;
                        }
                        if (element instanceof RefRole) {
                            return true;
                        }
                        if (element instanceof RefRequirement) {
                            return true;
                        }
                        return element instanceof RefTechnique;
                    }
                };
                tviewer.addFilter(modelFilter);
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Not valid model file", (String)"The provided model file couldn't be parsed as an EMF resource");
                tviewer.setInput(null);
            }
        }
    }

    public Object[] getSelectedRefReq() {
        return this.results;
    }
}

