/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.impl.RootXMLContentHandlerImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.ecore.EcoreASResourceFactory;
import org.eclipse.ocl.pivot.internal.library.StandardLibraryContribution;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.AbstractASResourceFactory;

public class OCLASResourceFactory
extends AbstractASResourceFactory {
    private static @Nullable OCLASResourceFactory INSTANCE = null;
    private static final @NonNull ContentHandler PIVOT_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.eclipse.ocl.oclas", new String[]{"oclas"}, "xmi", "http://www.eclipse.org/ocl/2015/Pivot", null);

    static {
        OCLASResourceFactory.installContentHandler(0, PIVOT_CONTENT_HANDLER);
    }

    public static synchronized @NonNull OCLASResourceFactory getInstance() {
        if (INSTANCE == null) {
            Map extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
            Object object = extensionToFactoryMap.get("oclas");
            INSTANCE = object instanceof Resource.Factory.Descriptor ? (OCLASResourceFactory)((Resource.Factory.Descriptor)object).createFactory() : new OCLASResourceFactory();
            assert (INSTANCE != null);
            INSTANCE.install(null, null);
        }
        assert (INSTANCE != null);
        return INSTANCE;
    }

    public OCLASResourceFactory() {
        super("org.eclipse.ocl.oclas");
    }

    @Override
    public void configure(@NonNull ResourceSet resourceSet) {
        Resource.Factory.Registry resourceFactoryRegistry = resourceSet.getResourceFactoryRegistry();
        resourceFactoryRegistry.getExtensionToFactoryMap().put("oclas", this);
    }

    @Override
    public Resource createResource(URI uri) {
        String nonASuriString;
        StandardLibraryContribution standardLibraryContribution;
        URI nonASuri = uri.trimFileExtension();
        String oclasExtension = nonASuri.fileExtension();
        ASResourceFactory asResourceFactory = ASResourceFactoryRegistry.INSTANCE.getASResourceFactoryForExtension(oclasExtension);
        if (asResourceFactory == null || !nonASuri.isFile()) {
            if (uri.isFile() && URIConverter.INSTANCE.exists(uri, null)) {
                return super.createResource(uri);
            }
            if (uri.isPlatform()) {
                URI deresolvedURI;
                URI pluginURI;
                if (URIConverter.INSTANCE.exists(uri, null)) {
                    return super.createResource(uri);
                }
                if (uri.isPlatformResource() && EMFPlugin.IS_ECLIPSE_RUNNING && URIConverter.INSTANCE.exists(pluginURI = (deresolvedURI = uri.deresolve(URI.createPlatformResourceURI((String)"/", (boolean)true))).resolve(URI.createPlatformPluginURI((String)"/", (boolean)true)), null)) {
                    return super.createResource(pluginURI);
                }
            }
        }
        if ((standardLibraryContribution = StandardLibraryContribution.REGISTRY.get(nonASuriString = nonASuri.toString())) != null) {
            return standardLibraryContribution.getResource();
        }
        if (asResourceFactory == null) {
            asResourceFactory = EcoreASResourceFactory.getInstance();
        }
        assert (!(asResourceFactory instanceof OCLASResourceFactory));
        return asResourceFactory.createResource(uri);
    }

    @Override
    public @NonNull ASResourceFactory getASResourceFactory() {
        return OCLASResourceFactory.getInstance();
    }
}

