/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractIteration;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class ExistsIteration
extends AbstractIteration {
    public static final @NonNull ExistsIteration INSTANCE = new ExistsIteration();

    @Override
    @Deprecated
    public @NonNull Object createAccumulatorValue(@NonNull Evaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return this.createAccumulatorValue(ValueUtil.getExecutor(evaluator), accumulatorTypeId, bodyTypeId);
    }

    @Override
    public @NonNull Object createAccumulatorValue(@NonNull Executor executor, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return new AbstractIteration.MutableObject(Boolean.FALSE);
    }

    @Override
    protected @Nullable Object resolveTerminalValue(@NonNull IterationManager iterationManager) {
        AbstractIteration.MutableObject accumulatorValue = (AbstractIteration.MutableObject)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        Object object = accumulatorValue.get();
        if (object == null || object == Boolean.FALSE) {
            return object;
        }
        throw (InvalidValueException)object;
    }

    @Override
    protected @Nullable Object updateAccumulator(@NonNull IterationManager iterationManager) {
        try {
            Object bodyVal = iterationManager.evaluateBody();
            if (bodyVal == Boolean.TRUE) {
                return Boolean.TRUE;
            }
            if (bodyVal == Boolean.FALSE) {
                return CARRY_ON;
            }
            if (bodyVal == null) {
                AbstractIteration.MutableObject accumulatorValue = (AbstractIteration.MutableObject)iterationManager.getAccumulatorValue();
                assert (accumulatorValue != null);
                if (accumulatorValue.get() == Boolean.FALSE) {
                    accumulatorValue.set(null);
                }
                return CARRY_ON;
            }
            throw new InvalidValueException(PivotMessages.NonBooleanBody, "exists");
        }
        catch (EvaluationHaltedException e) {
            throw e;
        }
        catch (InvalidValueException e) {
            AbstractIteration.MutableObject accumulatorValue = (AbstractIteration.MutableObject)iterationManager.getAccumulatorValue();
            assert (accumulatorValue != null);
            accumulatorValue.set(e);
            return CARRY_ON;
        }
        catch (Exception e) {
            AbstractIteration.MutableObject accumulatorValue = (AbstractIteration.MutableObject)iterationManager.getAccumulatorValue();
            assert (accumulatorValue != null);
            accumulatorValue.set(ValueUtil.createInvalidValue(e));
            return CARRY_ON;
        }
    }
}

