/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerManager;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckoutManager;
import org.eclipse.emf.cdo.explorer.ui.ViewerUtil;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentModifier;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutLabelProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutState;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutStateManager;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutViewerRefresh;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.OpenWithActionProvider;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.views.ItemProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOCheckoutContentProvider
implements ICommonContentProvider,
IPropertySourceProvider,
IOpenListener {
    private static final Map<String, CDOCheckoutContentProvider> INSTANCES = new HashMap<String, CDOCheckoutContentProvider>();
    private static final Set<Object> LOADING_OBJECTS = new HashSet<Object>();
    private static final Method GET_CHILDREN_FEATURES_METHOD = CDOCheckoutContentProvider.getMethod(ItemProviderAdapter.class, "getChildrenFeatures", Object.class);
    private static final Method FIND_ITEM_METHOD = CDOCheckoutContentProvider.getMethod(StructuredViewer.class, "findItem", Object.class);
    private static final CDOCheckoutManager CHECKOUT_MANAGER = CDOExplorerUtil.getCheckoutManager();
    private final IListener checkoutManagerListener = new IListener(){

        public void notifyEvent(IEvent event) {
            CDOCheckoutViewerRefresh viewerRefresh = CDOCheckoutContentProvider.this.stateManager.getViewerRefresh();
            if (event instanceof IContainerEvent) {
                viewerRefresh.addNotification(null, true, true);
            } else if (event instanceof CDOCheckoutManager.CheckoutStateEvent) {
                CDOCheckoutManager.CheckoutStateEvent e = (CDOCheckoutManager.CheckoutStateEvent)event;
                CDOCheckout checkout = e.getCheckout();
                CDOCheckout.State state = e.getNewState();
                if (state == CDOCheckout.State.Opening) {
                    ViewerUtil.refresh((StructuredViewer)CDOCheckoutContentProvider.this.viewer, checkout);
                    ViewerUtil.expand(CDOCheckoutContentProvider.this.viewer, checkout, true);
                } else {
                    if (state == CDOCheckout.State.Closed) {
                        ViewerUtil.expand(CDOCheckoutContentProvider.this.viewer, checkout, false);
                    }
                    viewerRefresh.addNotification(checkout, true, true);
                    if (state == CDOCheckout.State.Open) {
                        ViewerUtil.expand(CDOCheckoutContentProvider.this.viewer, checkout, true);
                    }
                    this.updatePropertySheetPage(checkout);
                }
            } else if (event instanceof CDOExplorerManager.ElementsChangedEvent) {
                CDOExplorerManager.ElementsChangedEvent e = (CDOExplorerManager.ElementsChangedEvent)event;
                CDOExplorerManager.ElementsChangedEvent.StructuralImpact structuralImpact = e.getStructuralImpact();
                Object[] changedElements = e.getChangedElements();
                if (structuralImpact != CDOExplorerManager.ElementsChangedEvent.StructuralImpact.NONE && changedElements.length == 1) {
                    Object changedElement = changedElements[0];
                    if (changedElement instanceof CDOElement) {
                        changedElement = ((CDOElement)changedElement).getParent();
                    }
                    if (structuralImpact == CDOExplorerManager.ElementsChangedEvent.StructuralImpact.PARENT) {
                        changedElement = CDOExplorerUtil.getParent((Object)changedElement);
                    }
                    viewerRefresh.addNotification(changedElement, true, true);
                } else {
                    Object[] objectArray = changedElements;
                    int n = changedElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object changedElement = objectArray[n2];
                        viewerRefresh.addNotification(changedElement, false, true);
                        ++n2;
                    }
                }
                this.updatePropertySheetPage(changedElements);
            }
        }

        private void updatePropertySheetPage(final Object element) {
            Control control;
            IPage currentPage;
            IWorkbenchPage workbenchPage = CDOCheckoutContentProvider.this.getWorkbenchPage();
            PropertySheet propertySheet = this.getPropertySheet(workbenchPage);
            if (propertySheet != null && ((currentPage = propertySheet.getCurrentPage()) instanceof PropertySheetPage || currentPage instanceof TabbedPropertySheetPage) && !(control = CDOCheckoutContentProvider.this.viewer.getControl()).isDisposed()) {
                control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        IStructuredSelection selection;
                        if (!control.isDisposed() && (selection = (IStructuredSelection)CDOCheckoutContentProvider.this.viewer.getSelection()).size() == 1) {
                            Object[] objectArray = selection.toArray();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object object = objectArray[n2];
                                if (object == element) {
                                    if (currentPage instanceof PropertySheetPage) {
                                        ((PropertySheetPage)currentPage).refresh();
                                    } else if (currentPage instanceof TabbedPropertySheetPage) {
                                        ((TabbedPropertySheetPage)currentPage).refresh();
                                    }
                                    return;
                                }
                                ++n2;
                            }
                        }
                    }
                });
            }
        }

        private PropertySheet getPropertySheet(IWorkbenchPage workbenchPage) {
            IViewReference[] iViewReferenceArray = workbenchPage.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewPart view;
                IViewReference viewReference = iViewReferenceArray[n2];
                if ("org.eclipse.ui.views.PropertySheet".equals(viewReference.getId()) && (view = viewReference.getView(false)) instanceof PropertySheet) {
                    return (PropertySheet)view;
                }
                ++n2;
            }
            return null;
        }
    };
    private final CDOCheckoutStateManager stateManager = new CDOCheckoutStateManager(this);
    private final Map<Object, Object[]> childrenCache = new ConcurrentHashMap<Object, Object[]>();
    private String viewerID;
    private TreeViewer viewer;
    private Object input;
    public static final String PROJECT_EXPLORER_ID = "org.eclipse.ui.navigator.ProjectExplorer";

    public void init(ICommonContentExtensionSite config) {
        this.viewerID = config.getService().getViewerId();
        INSTANCES.put(this.viewerID, this);
        CHECKOUT_MANAGER.addListener(this.checkoutManagerListener);
    }

    public void saveState(IMemento aMemento) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void dispose() {
        CHECKOUT_MANAGER.removeListener(this.checkoutManagerListener);
        INSTANCES.remove(this.viewerID);
    }

    public void disposeWith(Control control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CDOCheckoutContentProvider.this.dispose();
            }
        });
    }

    public final CDOCheckoutStateManager getStateManager() {
        return this.stateManager;
    }

    public final TreeViewer getViewer() {
        return this.viewer;
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        TreeViewer newTreeViewer = null;
        if (newViewer instanceof TreeViewer) {
            newTreeViewer = (TreeViewer)newViewer;
        }
        if (newTreeViewer != this.viewer) {
            if (this.viewer != null) {
                this.viewer.removeOpenListener((IOpenListener)this);
            }
            this.viewer = newTreeViewer;
            if (this.viewer != null) {
                this.viewer.addOpenListener((IOpenListener)this);
            }
        }
        this.input = newInput;
        this.stateManager.inputChanged(newTreeViewer, oldInput, newInput);
    }

    public Object getInput() {
        return this.input;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object object) {
        try {
            CDOCheckoutState.ContentProvider contentProvider;
            InternalCDORevision revision;
            EObject eObject;
            InternalCDOObject cdoObject;
            if (object instanceof IResource) {
                if (!(object instanceof IWorkspaceRoot)) return false;
                if (!CHECKOUT_MANAGER.isEmpty()) return true;
                return false;
            }
            if (object instanceof ViewerUtil.Pending) {
                return false;
            }
            if (object instanceof CDOCheckout) {
                CDOCheckout checkout = (CDOCheckout)object;
                switch (checkout.getState()) {
                    case Closing: 
                    case Closed: {
                        return false;
                    }
                    case Opening: {
                        return true;
                    }
                    case Open: {
                        object = checkout.getRootObject();
                        break;
                    }
                }
            }
            if (object instanceof CDOElement) {
                CDOElement checkoutElement = (CDOElement)object;
                return checkoutElement.hasChildren();
            }
            if (GET_CHILDREN_FEATURES_METHOD != null && object instanceof EObject && (cdoObject = CDOCheckoutContentProvider.getCDOObject(eObject = (EObject)object)) != null && (revision = cdoObject.cdoRevision(false)) != null) {
                try {
                    ITreeItemContentProvider provider = (ITreeItemContentProvider)this.stateManager.adapt(object, ITreeItemContentProvider.class);
                    if (provider instanceof ItemProviderAdapter) {
                        return CDOCheckoutContentProvider.hasChildren(cdoObject, revision, (ItemProviderAdapter)provider);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((contentProvider = this.stateManager.getContentProvider(object)) == null) return false;
            return contentProvider.hasChildren(object);
        }
        catch (LifecycleException contentProvider) {
            return false;
        }
        catch (RuntimeException ex) {
            if (!LifecycleUtil.isActive((Object)object)) return false;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object object) {
        block28: {
            try {
                boolean firstLoad;
                if (object instanceof IResource) {
                    if (object instanceof IWorkspaceRoot) {
                        return CHECKOUT_MANAGER.getCheckouts();
                    }
                    return ViewerUtil.NO_CHILDREN;
                }
                if (object instanceof ViewerUtil.Pending) {
                    return ViewerUtil.NO_CHILDREN;
                }
                if (object instanceof CDOElement) {
                    CDOElement checkoutElement = (CDOElement)object;
                    return checkoutElement.getChildren();
                }
                Object originalObject = object;
                Object[] children = this.childrenCache.remove(originalObject);
                if (children != null) {
                    return children;
                }
                CDOCheckout openingCheckout = null;
                CDOCheckout checkout = null;
                if (object instanceof CDOCheckout) {
                    checkout = (CDOCheckout)object;
                    switch (checkout.getState()) {
                        case Closing: 
                        case Closed: {
                            return ViewerUtil.NO_CHILDREN;
                        }
                        case Opening: {
                            openingCheckout = checkout;
                            break;
                        }
                        case Open: {
                            object = checkout.getRootObject();
                        }
                    }
                }
                final Object finalObject = object;
                final CDOCheckout finalOpeningCheckout = openingCheckout;
                CDOCheckoutState.ContentProvider contentProvider = this.stateManager.getContentProvider(finalObject);
                if (contentProvider == null) {
                    return ItemProvider.NO_ELEMENTS;
                }
                final ArrayList<CDORevision> loadedRevisions = new ArrayList<CDORevision>();
                final ArrayList<CDOID> missingIDs = new ArrayList<CDOID>();
                if (openingCheckout == null && (children = this.determineChildRevisions(object, loadedRevisions, missingIDs)) != null) {
                    return CDOCheckoutContentModifier.Registry.INSTANCE.modifyChildren(object, children);
                }
                Set<Object> set = LOADING_OBJECTS;
                synchronized (set) {
                    firstLoad = LOADING_OBJECTS.add(originalObject);
                }
                if (firstLoad || finalOpeningCheckout == null) {
                    Job job = new Job("Load " + finalObject, (ITreeContentProvider)contentProvider, originalObject){
                        private final /* synthetic */ ITreeContentProvider val$contentProvider;
                        private final /* synthetic */ Object val$originalObject;
                        {
                            this.val$contentProvider = iTreeContentProvider;
                            this.val$originalObject = object2;
                            super($anonymous0);
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            block7: {
                                try {
                                    if (finalOpeningCheckout != null) {
                                        finalOpeningCheckout.open();
                                        CDOCheckoutContentProvider.this.determineChildRevisions(finalObject, loadedRevisions, missingIDs);
                                    }
                                    if (!missingIDs.isEmpty()) {
                                        InternalCDOObject cdoObject = CDOCheckoutContentProvider.getCDOObject((EObject)finalObject);
                                        CDOView view = cdoObject.cdoView();
                                        CDORevisionManager revisionManager = view.getSession().getRevisionManager();
                                        List revisions = revisionManager.getRevisions(missingIDs, (CDOBranchPoint)view, -1, 0, true);
                                        loadedRevisions.addAll(revisions);
                                    }
                                    Object[] children = this.val$contentProvider.getChildren(finalObject);
                                    int i = 0;
                                    while (i < children.length) {
                                        InternalCDOObject cdoObject;
                                        InternalEObject instance;
                                        Object child = children[i];
                                        if (child instanceof InternalCDOObject && (instance = (cdoObject = (InternalCDOObject)child).cdoInternalInstance()) != cdoObject) {
                                            children[i] = instance;
                                        }
                                        ++i;
                                    }
                                    children = CDOCheckoutContentModifier.Registry.INSTANCE.modifyChildren(finalObject, children);
                                    CDOCheckoutContentProvider.this.childrenCache.put(this.val$originalObject, children);
                                }
                                catch (Exception ex) {
                                    CDOCheckoutContentProvider.this.childrenCache.remove(this.val$originalObject);
                                    if (finalOpeningCheckout != null) {
                                        finalOpeningCheckout.close();
                                    }
                                    OM.LOG.error((Throwable)ex);
                                    final Control control = CDOCheckoutContentProvider.this.viewer.getControl();
                                    if (control.isDisposed()) break block7;
                                    UIUtil.getDisplay().asyncExec(new Runnable(){

                                        public void run() {
                                            try {
                                                if (!control.isDisposed()) {
                                                    Shell shell = control.getShell();
                                                    String title = String.valueOf(finalOpeningCheckout != null ? "Open" : "Load") + " Error";
                                                    MessageDialog.openError((Shell)shell, (String)title, (String)ex.getMessage());
                                                }
                                            }
                                            catch (Exception ex2) {
                                                OM.LOG.error((Throwable)ex2);
                                            }
                                        }
                                    });
                                }
                            }
                            CDOCheckoutViewerRefresh viewerRefresh = CDOCheckoutContentProvider.this.stateManager.getViewerRefresh();
                            viewerRefresh.addNotification(this.val$originalObject, true, true, new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    Set set = LOADING_OBJECTS;
                                    synchronized (set) {
                                        LOADING_OBJECTS.remove(val$originalObject);
                                    }
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
                if (FIND_ITEM_METHOD != null) {
                    try {
                        TreeItem item;
                        TreeItem[] childItems;
                        int childCount;
                        Object widget = FIND_ITEM_METHOD.invoke((Object)this.viewer, originalObject);
                        if (widget instanceof TreeItem && (childCount = (childItems = (item = (TreeItem)widget).getItems()).length) != 0) {
                            ArrayList<Object> result = new ArrayList<Object>();
                            int i = 0;
                            while (i < childCount) {
                                TreeItem childItem = childItems[i];
                                Object child = childItem.getData();
                                if (child != null) {
                                    result.add(child);
                                }
                                ++i;
                            }
                            int size = result.size();
                            if (size != 0) {
                                return result.toArray(new Object[size]);
                            }
                        }
                    }
                    catch (Exception widget) {
                        // empty catch block
                    }
                }
                String text = "Loading...";
                if (finalOpeningCheckout != null) {
                    text = "Opening...";
                }
                return new Object[]{new ViewerUtil.Pending(originalObject, text)};
            }
            catch (LifecycleException originalObject) {
            }
            catch (RuntimeException ex) {
                if (!LifecycleUtil.isActive((Object)object)) break block28;
                throw ex;
            }
        }
        return ItemProvider.NO_ELEMENTS;
    }

    private Object[] determineChildRevisions(Object object, List<CDORevision> loadedRevisions, List<CDOID> missingIDs) {
        InternalCDORevision revision;
        EObject eObject;
        InternalCDOObject cdoObject;
        if (GET_CHILDREN_FEATURES_METHOD != null && object instanceof EObject && (cdoObject = CDOCheckoutContentProvider.getCDOObject(eObject = (EObject)object)) != null && (revision = cdoObject.cdoRevision(false)) != null) {
            try {
                ITreeItemContentProvider provider = (ITreeItemContentProvider)this.stateManager.adapt(object, ITreeItemContentProvider.class);
                if (provider instanceof ItemProviderAdapter) {
                    CDOCheckoutState.ContentProvider contentProvider;
                    CDOCheckoutContentProvider.determineChildRevisions(cdoObject, revision, (ItemProviderAdapter)provider, loadedRevisions, missingIDs);
                    if (missingIDs.isEmpty() && (contentProvider = this.stateManager.getContentProvider(object)) != null) {
                        return contentProvider.getChildren(object);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Object getParent(Object object) {
        block10: {
            try {
                if (object instanceof CDOCheckout) {
                    return ResourcesPlugin.getWorkspace().getRoot();
                }
                if (object instanceof ViewerUtil.Pending) {
                    return ((ViewerUtil.Pending)object).getParent();
                }
                if (object instanceof CDOElement) {
                    CDOElement checkoutElement = (CDOElement)object;
                    return checkoutElement.getParent();
                }
                if (object instanceof EObject) {
                    EObject eObject = CDOUtil.getEObject((EObject)((EObject)object));
                    CDOElement element = CDOElement.getFor((Object)eObject);
                    if (element != null) {
                        return element;
                    }
                    CDOCheckoutState.ContentProvider contentProvider = this.stateManager.getContentProvider(object);
                    if (contentProvider != null) {
                        EObject eParent;
                        Adapter adapter;
                        Object parent = contentProvider.getParent(object);
                        if (parent instanceof EObject && (adapter = EcoreUtil.getAdapter((List)(eParent = (EObject)parent).eAdapters(), CDOCheckout.class)) != null) {
                            return adapter;
                        }
                        return parent;
                    }
                }
            }
            catch (LifecycleException eObject) {
            }
            catch (RuntimeException ex) {
                if (!LifecycleUtil.isActive((Object)object)) break block10;
                throw ex;
            }
        }
        return null;
    }

    public IPropertySource getPropertySource(Object object) {
        CDOCheckoutState.ContentProvider contentProvider = this.stateManager.getContentProvider(object);
        if (contentProvider != null) {
            return contentProvider.getPropertySource(object);
        }
        return null;
    }

    public void selectObjects(final Object ... objects) {
        final Control control = this.viewer.getControl();
        if (!control.isDisposed()) {
            final long end = System.currentTimeMillis() + 5000L;
            final Display display = control.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (control.isDisposed()) {
                        return;
                    }
                    Object[] objectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        LinkedList path = new LinkedList();
                        CDOCheckout checkout = CDOExplorerUtil.walkUp((Object)object, path);
                        if (checkout != null) {
                            CDOCheckoutContentProvider.this.viewer.setExpandedState((Object)checkout, true);
                            if (!path.isEmpty()) {
                                path.removeFirst();
                            }
                            if (!path.isEmpty()) {
                                path.removeLast();
                            }
                            for (Object parent : path) {
                                CDOCheckoutContentProvider.this.viewer.setExpandedState(parent, true);
                            }
                        }
                        ++n2;
                    }
                    CDOCheckoutContentProvider.this.viewer.setSelection((ISelection)new StructuredSelection(objects), true);
                    IStructuredSelection selection = (IStructuredSelection)CDOCheckoutContentProvider.this.viewer.getSelection();
                    HashSet<Object> actual = new HashSet<Object>(Arrays.asList(selection.toArray()));
                    HashSet<Object> expected = new HashSet<Object>(Arrays.asList(objects));
                    if (!actual.equals(expected) && (CDOCheckoutContentProvider.isObjectLoading(objects) || System.currentTimeMillis() < end)) {
                        display.timerExec(50, (Runnable)this);
                    }
                }
            });
        }
    }

    public void open(OpenEvent event) {
        IStructuredSelection ssel;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).size() == 1) {
            Object element = ssel.getFirstElement();
            if (element instanceof CDOCheckout) {
                final CDOCheckout checkout = (CDOCheckout)element;
                if (checkout.getState() == CDOCheckout.State.Closed) {
                    new Job("Open " + checkout.getLabel()){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                checkout.open();
                            }
                            catch (Exception ex) {
                                OM.LOG.error((Throwable)ex);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            } else if (!(element instanceof CDOResourceNode) && element instanceof EObject) {
                EObject eObject = (EObject)element;
                Shell shell = this.getWorkbenchPage().getWorkbenchWindow().getShell();
                ComposedAdapterFactory adapterFactory = this.stateManager.getAdapterFactory(eObject);
                OpenWithActionProvider.editObject(shell, adapterFactory, eObject);
            }
        }
    }

    private IWorkbenchPage getWorkbenchPage() {
        if (this.viewer instanceof CommonViewer) {
            CommonViewer commonViewer = (CommonViewer)this.viewer;
            return commonViewer.getCommonNavigator().getSite().getPage();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private static InternalCDOObject getCDOObject(EObject eObject) {
        return (InternalCDOObject)CDOUtil.getCDOObject((EObject)eObject, (boolean)false);
    }

    private static boolean hasChildren(InternalCDOObject cdoObject, InternalCDORevision revision, ItemProviderAdapter provider) throws Exception {
        for (EStructuralFeature eStructuralFeature : CDOCheckoutContentProvider.getChildrenFeatures(cdoObject, provider)) {
            if (!(eStructuralFeature.isMany() ? !revision.isEmpty(eStructuralFeature) : revision.getValue(eStructuralFeature) != null)) continue;
            return true;
        }
        return false;
    }

    private static void determineChildRevisions(InternalCDOObject cdoObject, InternalCDORevision revision, ItemProviderAdapter provider, List<CDORevision> loadedRevisions, List<CDOID> missingIDs) throws Exception {
        InternalCDOView view = cdoObject.cdoView();
        InternalCDORevisionCache revisionCache = view.getSession().getRevisionManager().getCache();
        for (EStructuralFeature eStructuralFeature : CDOCheckoutContentProvider.getChildrenFeatures(cdoObject, provider)) {
            if (eStructuralFeature.isMany()) {
                CDOList list = revision.getList(eStructuralFeature);
                for (Object object : list) {
                    CDOCheckoutContentProvider.determineChildRevision(loadedRevisions, missingIDs, view, revisionCache, object);
                }
                continue;
            }
            Object value = revision.getValue(eStructuralFeature);
            CDOCheckoutContentProvider.determineChildRevision(loadedRevisions, missingIDs, view, revisionCache, value);
        }
    }

    private static void determineChildRevision(List<CDORevision> loadedRevisions, List<CDOID> missingIDs, InternalCDOView view, InternalCDORevisionCache cache, Object object) {
        if (object instanceof CDOID) {
            CDOID id = (CDOID)object;
            CDORevision childRevision = cache.getRevision(id, (CDOBranchPoint)view);
            if (childRevision != null) {
                loadedRevisions.add(childRevision);
            } else {
                missingIDs.add(id);
            }
        }
    }

    private static Collection<? extends EStructuralFeature> getChildrenFeatures(InternalCDOObject cdoObject, ItemProviderAdapter provider) throws Exception {
        return (Collection)GET_CHILDREN_FEATURES_METHOD.invoke((Object)provider, cdoObject);
    }

    private static Method getMethod(Class<?> c, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = c.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isObjectLoading(Object ... objects) {
        Set<Object> set = LOADING_OBJECTS;
        synchronized (set) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Object object = objectArray[n2];
                if (LOADING_OBJECTS.contains(object)) {
                    return true;
                }
                ++n2;
            }
        }
    }

    public static TreeViewer createTreeViewer(Composite container) {
        CDOItemProvider parentItemProvider = new CDOItemProvider(null){

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length != 0;
            }

            public Object[] getChildren(Object element) {
                ArrayList<Object> children = new ArrayList<Object>();
                Object[] objectArray = this.doGetChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (child instanceof CDOCheckout || child instanceof CDOResourceFolder) {
                        children.add(child);
                    }
                    ++n2;
                }
                return children.toArray();
            }

            private Object[] doGetChildren(Object element) {
                CDOCheckout checkout;
                if (element instanceof CDOCheckout && (checkout = (CDOCheckout)element).isOpen()) {
                    return checkout.getRootObject().eContents().toArray();
                }
                return super.getChildren(element);
            }

            public void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
            }
        };
        CDOCheckoutContentProvider contentProvider = new CDOCheckoutContentProvider();
        contentProvider.disposeWith((Control)container);
        CDOCheckoutLabelProvider labelProvider = new CDOCheckoutLabelProvider(contentProvider);
        TreeViewer parentViewer = new TreeViewer(container, 2048);
        parentViewer.setContentProvider((IContentProvider)parentItemProvider);
        parentViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        parentViewer.setInput((Object)CDOExplorerUtil.getCheckoutManager());
        return parentViewer;
    }

    public static final CDOCheckoutContentProvider getInstance(String viewerID) {
        return INSTANCES.get(viewerID);
    }
}

