/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.sam.arg.arg.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.opencert.sam.arg.arg.ArgumentationElement;
import org.eclipse.opencert.sam.arg.arg.AssertedContext;
import org.eclipse.opencert.sam.arg.arg.Case;
import org.eclipse.opencert.sam.arg.arg.diagram.edit.policies.ArgBaseItemSemanticEditPolicy;

public class AssertedContextReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public AssertedContextReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof AssertedContext)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ArgumentationElement) || !(this.newEnd instanceof ArgumentationElement)) {
            return false;
        }
        if (this.getLink().getTarget().size() != 1) {
            return false;
        }
        ArgumentationElement target = (ArgumentationElement)this.getLink().getTarget().get(0);
        if (!(this.getLink().eContainer() instanceof Case)) {
            return false;
        }
        Case container = (Case)this.getLink().eContainer();
        return ArgBaseItemSemanticEditPolicy.getLinkConstraints().canExistAssertedContext_4003(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ArgumentationElement) || !(this.newEnd instanceof ArgumentationElement)) {
            return false;
        }
        if (this.getLink().getSource().size() != 1) {
            return false;
        }
        ArgumentationElement source = (ArgumentationElement)this.getLink().getSource().get(0);
        if (!(this.getLink().eContainer() instanceof Case)) {
            return false;
        }
        Case container = (Case)this.getLink().eContainer();
        return ArgBaseItemSemanticEditPolicy.getLinkConstraints().canExistAssertedContext_4003(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().getSource().remove((Object)this.getOldSource());
        this.getLink().getSource().add((Object)this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().getTarget().remove((Object)this.getOldTarget());
        this.getLink().getTarget().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected AssertedContext getLink() {
        return (AssertedContext)this.getElementToEdit();
    }

    protected ArgumentationElement getOldSource() {
        return (ArgumentationElement)this.oldEnd;
    }

    protected ArgumentationElement getNewSource() {
        return (ArgumentationElement)this.newEnd;
    }

    protected ArgumentationElement getOldTarget() {
        return (ArgumentationElement)this.oldEnd;
    }

    protected ArgumentationElement getNewTarget() {
        return (ArgumentationElement)this.newEnd;
    }
}

