/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.HighlightUtil;

public class HighlightEditPolicy
extends GraphicalEditPolicy {
    public static final String HIGHLIGHT_ROLE = "Highlight Edit Policy";
    protected Indicator sourceIndicator;
    protected Indicator targetIndicator;

    public void showTargetFeedback(Request request) {
        EditPart host = this.getHost();
        if ("drop_objects".equals(request.getType())) {
            this.highlight(host);
        }
    }

    protected void highlight(EditPart object) {
        HighlightUtil.highlight(object);
    }

    protected void unhighlight(EditPart object) {
        HighlightUtil.unhighlight(object);
    }

    protected void unhighlight() {
        HighlightUtil.unhighlight();
    }

    private void safeRemoveFeedback(IFigure feedback) {
        if (feedback == null || feedback.getParent() == null) {
            return;
        }
        feedback.getParent().remove(feedback);
    }

    public void eraseTargetFeedback(Request request) {
        this.unhighlight();
        this.safeRemoveFeedback((IFigure)this.sourceIndicator);
        this.sourceIndicator = null;
        this.safeRemoveFeedback((IFigure)this.targetIndicator);
        this.targetIndicator = null;
    }

    public void eraseSourceFeedback(Request request) {
        super.eraseSourceFeedback(request);
        this.safeRemoveFeedback((IFigure)this.sourceIndicator);
        this.sourceIndicator = null;
        this.safeRemoveFeedback((IFigure)this.targetIndicator);
        this.targetIndicator = null;
    }

    private static class Indicator
    extends Ellipse {
        public Indicator() {
            this.setLineWidth(2);
            this.setAntialias(1);
            this.setSize(10, 10);
        }
    }
}

