/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.internal.commands.switchers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editor.CoreMultiDiagramEditor;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.chessmlprofile.Core.CHESS;
import org.polarsys.chess.chessmlprofile.Core.Domain;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.service.utils.CHESSEditorUtils;

public class SwitchSourceProvider
extends AbstractSourceProvider {
    public static final String SWITCH = "org.polarsys.chess.service.commands.switchState";
    public static final String DOMAIN = "org.polarsys.chess.service.commands.domain";
    private static final String defaultDomain = Domain.CROSS_DOMAIN.name();
    private String currentDomain = defaultDomain;
    private static final String DISABLED = "disabled";
    private String currentState = "disabled";
    public static List<String> commandsToRefresh = new ArrayList<String>();

    public void dispose() {
    }

    public Map getCurrentState() {
        HashMap<String, String> currentSt = new HashMap<String, String>(2);
        currentSt.put(SWITCH, this.currentState);
        currentSt.put(DOMAIN, this.currentDomain);
        return currentSt;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{SWITCH};
    }

    private void setEnabledValue(String v) {
        this.currentState = v;
        this.fireSourceChanged(0, SWITCH, v);
    }

    private void setEnabledValueDomain(String d) {
        this.currentDomain = d;
        this.fireSourceChanged(0, DOMAIN, d);
    }

    public void updateStatus(IEditorPart activeEditor) {
        try {
            if (!CHESSEditorUtils.isCHESSProject(activeEditor)) {
                this.setEnabledValue(DISABLED);
                this.setEnabledValueDomain(defaultDomain);
            } else {
                DiagramStatus ds = CHESSEditorUtils.getDiagramStatus((PapyrusMultiDiagramEditor)activeEditor);
                if (ds == null) {
                    this.setEnabledValue(DISABLED);
                    this.setEnabledValueDomain(defaultDomain);
                } else {
                    DiagramStatus.DesignView currentView = ds.getCurrentView();
                    Resource res = ResourceUtils.getUMLResource((ServicesRegistry)((CoreMultiDiagramEditor)activeEditor).getServicesRegistry());
                    Model umlModel = ResourceUtils.getModel((Resource)res);
                    if (umlModel == null) {
                        this.setEnabledValueDomain(defaultDomain);
                    } else if (umlModel.getAppliedStereotype("CHESS::Core::CHESS") != null) {
                        Stereotype chessModelStereo = umlModel.getAppliedStereotype("CHESS::Core::CHESS");
                        CHESS chessModel = (CHESS)umlModel.getStereotypeApplication(chessModelStereo);
                        Domain theDomain = chessModel.getDomain();
                        this.setEnabledValueDomain(theDomain.name());
                    } else {
                        this.setEnabledValueDomain(defaultDomain);
                    }
                    if (currentView != null && (ViewUtils.hasConcurrentViews((DiagramStatus.DesignView)currentView) || ViewUtils.isConcurrentView((DiagramStatus.DesignView)currentView))) {
                        String name = ViewUtils.getBaseViewName((DiagramStatus.DesignView)currentView);
                        this.setEnabledValue(name);
                    } else {
                        this.setEnabledValue(DISABLED);
                    }
                }
            }
            this.refreshElements(activeEditor);
        }
        catch (Exception exception) {
            return;
        }
    }

    private void refreshElements(IEditorPart activeEditor) {
        ICommandService service = (ICommandService)activeEditor.getSite().getWorkbenchWindow().getService(ICommandService.class);
        for (String commandId : commandsToRefresh) {
            service.refreshElements(commandId, null);
        }
    }
}

