/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.pkm.refframework.refframework.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.opencert.pkm.refframework.refframework.RefActivity;
import org.eclipse.opencert.pkm.refframework.refframework.RefArtefact;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.edit.policies.RefframeworkBaseItemSemanticEditPolicy;

public class RefActivityRequiredArtefactReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public RefActivityRequiredArtefactReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof RefActivity)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof RefArtefact) || !(this.newEnd instanceof RefActivity)) {
            return false;
        }
        return RefframeworkBaseItemSemanticEditPolicy.getLinkConstraints().canExistRefActivityRequiredArtefact_4001(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof RefArtefact) || !(this.newEnd instanceof RefArtefact)) {
            return false;
        }
        return RefframeworkBaseItemSemanticEditPolicy.getLinkConstraints().canExistRefActivityRequiredArtefact_4001(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getRequiredArtefact().remove((Object)this.getOldTarget());
        this.getNewSource().getRequiredArtefact().add((Object)this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getOldSource().getRequiredArtefact().remove((Object)this.getOldTarget());
        this.getOldSource().getRequiredArtefact().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected RefActivity getOldSource() {
        return (RefActivity)this.referenceOwner;
    }

    protected RefActivity getNewSource() {
        return (RefActivity)this.newEnd;
    }

    protected RefArtefact getOldTarget() {
        return (RefArtefact)this.oldEnd;
    }

    protected RefArtefact getNewTarget() {
        return (RefArtefact)this.newEnd;
    }
}

