/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.net4j.util.container.FactoryNotFoundException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.ValidationContext;
import org.eclipse.net4j.util.ui.container.ElementWizard;
import org.eclipse.net4j.util.ui.container.IElementWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementWizardComposite
extends Composite
implements IListener {
    private static final IElementWizard NO_WIZARD = new ElementWizard(){

        protected void create(Composite parent) {
        }
    };
    private String productGroup;
    private String label;
    private List<String> factoryTypes;
    private String defaultFactoryType;
    private List<IElementWizard> wizards;
    private Map<IElementWizard, List<Control>> wizardControls = new HashMap<IElementWizard, List<Control>>();
    private Map<Control, IElementWizard> controlWizards = new HashMap<Control, IElementWizard>();
    private ValidationContext validationContext;
    private boolean firstLayout = true;
    private Notifier notifier = new Notifier();

    public ElementWizardComposite(Composite parent, int style, String productGroup, String label) {
        this(parent, style, productGroup, label, null);
    }

    public ElementWizardComposite(Composite parent, int style, String productGroup, String label, ValidationContext validationContext) {
        this(parent, style, productGroup, label, validationContext, null);
    }

    public ElementWizardComposite(Composite parent, int style, String productGroup, String label, ValidationContext validationContext, String defaultFactoryType) {
        super(parent, style);
        this.productGroup = productGroup;
        this.label = label;
        this.defaultFactoryType = defaultFactoryType;
        this.setValidationContext(validationContext);
        this.create();
    }

    public String getProductGroup() {
        return this.productGroup;
    }

    public String getLabel() {
        return this.label;
    }

    public void setValidationContext(ValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    public String getDefaultFactoryType() {
        return this.defaultFactoryType;
    }

    public String getDefaultDescription(String factoryType) {
        return null;
    }

    @Deprecated
    public void setDefaultDescription(String factoryType, String value) {
    }

    protected void init() {
        IManagedContainer container = this.getContainer();
        this.factoryTypes = new ArrayList<String>(container.getFactoryTypes(this.getProductGroup()));
        Collections.sort(this.factoryTypes);
        this.wizards = new ArrayList<IElementWizard>();
        this.wizardControls.put(NO_WIZARD, new ArrayList());
        Iterator<String> it = this.factoryTypes.iterator();
        while (it.hasNext()) {
            String factoryType = it.next();
            try {
                IElementWizard wizard = (IElementWizard)container.getElement("org.eclipse.net4j.util.ui.elementWizards", String.valueOf(this.getProductGroup()) + ":" + factoryType, null);
                this.wizards.add(wizard);
                this.wizardControls.put(wizard, new ArrayList());
                if (!(wizard instanceof ElementWizard)) continue;
                ElementWizard impl = (ElementWizard)wizard;
                impl.addListener(this);
            }
            catch (FactoryNotFoundException ex) {
                it.remove();
            }
        }
    }

    public void notifyEvent(IEvent event) {
        this.notifier.fireEvent(event);
    }

    protected List<String> getFactoryTypes() {
        return this.factoryTypes;
    }

    protected void create() {
        this.init();
        this.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)this, 0);
        label.setText(this.getLabel());
        label.setLayoutData((Object)UIUtil.createGridData(false, false));
        this.createFactoryTypeControl();
        this.harvestControls(NO_WIZARD);
        int i = 0;
        while (i < this.wizards.size()) {
            String factoryType = this.factoryTypes.get(i);
            String defaultDescription = this.getDefaultDescription(factoryType);
            IElementWizard wizard = this.wizards.get(i);
            wizard.create(this, this.getContainer(), this.productGroup, factoryType, defaultDescription, this.validationContext);
            this.harvestControls(wizard);
            ++i;
        }
        if (this.defaultFactoryType != null) {
            this.setFactoryType(this.defaultFactoryType);
        } else if (!this.factoryTypes.isEmpty()) {
            this.setFactoryType(this.factoryTypes.get(0));
        }
    }

    protected void factoryTypeChanged() {
        String newFactoryType = this.getFactoryType();
        ArrayList<Control> controlsToRefresh = new ArrayList<Control>();
        int i = 0;
        while (i < this.wizards.size()) {
            IElementWizard wizard = this.wizards.get(i);
            String factoryType = this.factoryTypes.get(i);
            boolean visible = factoryType.equals(newFactoryType);
            for (Control control : this.wizardControls.get(wizard)) {
                control.setVisible(visible);
                if (!visible) {
                    control.moveBelow(null);
                }
                controlsToRefresh.add(control);
            }
            ++i;
        }
        this.layout();
        this.notifier.fireEvent();
    }

    public void layout() {
        if (this.firstLayout) {
            super.layout();
            this.firstLayout = false;
        } else {
            super.layout(this.getChildren());
        }
    }

    protected void harvestControls(IElementWizard wizard) {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!this.controlWizards.containsKey(child)) {
                this.controlWizards.put(child, wizard);
                this.wizardControls.get(wizard).add(child);
            }
            ++n2;
        }
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    public final INotifier getNotifier() {
        return this.notifier;
    }

    public String getDescription() {
        String resultType = this.getFactoryType();
        int i = 0;
        while (i < this.wizards.size()) {
            String factoryType = this.factoryTypes.get(i);
            if (resultType.equals(factoryType)) {
                return this.wizards.get(i).getResultDescription();
            }
            ++i;
        }
        return null;
    }

    public abstract String getFactoryType();

    protected abstract void setFactoryType(String var1);

    protected abstract void createFactoryTypeControl();

    public static class WithCombo
    extends ElementWizardComposite
    implements SelectionListener {
        private Combo combo;

        public WithCombo(Composite parent, int style, String productGroup, String label) {
            super(parent, style, productGroup, label);
        }

        public WithCombo(Composite parent, int style, String productGroup, String label, ValidationContext validationContext) {
            super(parent, style, productGroup, label, validationContext);
        }

        public WithCombo(Composite parent, int style, String productGroup, String label, ValidationContext validationContext, String defaultFactoryType) {
            super(parent, style, productGroup, label, validationContext, defaultFactoryType);
        }

        public void widgetSelected(SelectionEvent e) {
            this.factoryTypeChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public String getFactoryType() {
            return this.combo.getText();
        }

        protected void setFactoryType(String factoryType) {
            int index = this.getFactoryTypes().indexOf(factoryType);
            if (index == -1) {
                this.combo.setText(factoryType);
            } else {
                this.combo.select(index);
            }
            this.factoryTypeChanged();
        }

        protected void createFactoryTypeControl() {
            this.combo = new Combo((Composite)this, 4);
            for (String factoryType : this.getFactoryTypes()) {
                this.combo.add(factoryType);
            }
            this.combo.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.combo.addSelectionListener((SelectionListener)this);
        }
    }

    public static class WithRadios
    extends ElementWizardComposite
    implements SelectionListener {
        private Composite composite;

        public WithRadios(Composite parent, int style, String productGroup, String label) {
            super(parent, style, productGroup, label);
        }

        public WithRadios(Composite parent, int style, String productGroup, String label, ValidationContext validationContext) {
            super(parent, style, productGroup, label, validationContext);
        }

        public WithRadios(Composite parent, int style, String productGroup, String label, ValidationContext validationContext, String defaultFactoryType) {
            super(parent, style, productGroup, label, validationContext, defaultFactoryType);
        }

        public void widgetSelected(SelectionEvent e) {
            this.factoryTypeChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public String getFactoryType() {
            Control[] choices = this.composite.getChildren();
            int i = 0;
            while (i < choices.length) {
                Button choice = (Button)choices[i];
                if (choice.getSelection()) {
                    return this.getFactoryTypes().get(i);
                }
                ++i;
            }
            return null;
        }

        protected void setFactoryType(String factoryType) {
            List<String> factoryTypes = this.getFactoryTypes();
            Control[] choices = this.composite.getChildren();
            int i = 0;
            while (i < factoryTypes.size()) {
                Button choice = (Button)choices[i];
                choice.setSelection(factoryTypes.get(i).equals(factoryType));
                ++i;
            }
            this.factoryTypeChanged();
        }

        protected void createFactoryTypeControl() {
            this.composite = new Composite((Composite)this, 4);
            this.composite.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.composite.setLayout((Layout)new FillLayout());
            for (String factoryType : this.getFactoryTypes()) {
                Button choice = new Button(this.composite, 16);
                choice.setText(factoryType);
                choice.addSelectionListener((SelectionListener)this);
            }
        }
    }
}

